/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import mcmultipart.api.container.IPartInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireUtils;

@SideOnly(value=Side.CLIENT)
public class WireHighlightHandler {
    @SubscribeEvent
    public void drawWireHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget() != null && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = event.getTarget().func_178782_a();
            Wire wire = event.getTarget().hitInfo instanceof IPartInfo ? WireUtils.getAnyWire(((IPartInfo)event.getTarget().hitInfo).getTile().getTileEntity()) : WireUtils.getAnyWire((IBlockAccess)event.getPlayer().func_130014_f_(), pos);
            if (wire != null) {
                event.setCanceled(true);
                int lineMaskCenter = 4095;
                EnumFacing[] faces = WireUtils.getConnectionsForRender(wire.getLocation());
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
                for (int i = 0; i < faces.length; ++i) {
                    EnumFacing face = faces[i];
                    if (!wire.connectsAny(face)) continue;
                    int lineMask = 4095;
                    RenderUtils.drawSelectionBoundingBox(wire.getProvider().getSelectionBox(wire.getLocation(), i + 1), lineMask &= ~RenderUtils.getSelectionMask(face.func_176734_d()));
                    lineMaskCenter &= ~RenderUtils.getSelectionMask(face);
                }
                if (lineMaskCenter != 0) {
                    RenderUtils.drawSelectionBoundingBox(wire.getProvider().getSelectionBox(wire.getLocation(), 0), lineMaskCenter);
                }
                GlStateManager.func_179121_F();
            }
        }
    }
}

