/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.scheduler;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.charset.lib.scheduler.ScheduledEvent;

public class Scheduler {
    public static final Scheduler INSTANCE = new Scheduler();
    private final Map<World, TLongObjectMap<Queue<ScheduledEvent>>> schedule = new WeakHashMap<World, TLongObjectMap<Queue<ScheduledEvent>>>();

    public ScheduledEvent in(World world, int ticks, Runnable runnable) {
        return this.at(world, world.func_82737_E() + (long)ticks, runnable);
    }

    public ScheduledEvent at(World world, long targetTime, Runnable runnable) {
        TLongObjectMap requests = this.schedule.computeIfAbsent(world, k -> new TLongObjectHashMap());
        ArrayDeque<ScheduledEvent> queue = (ArrayDeque<ScheduledEvent>)requests.get(targetTime);
        if (queue == null) {
            queue = new ArrayDeque<ScheduledEvent>();
            requests.put(targetTime, queue);
        }
        ScheduledEvent event = new ScheduledEvent(runnable);
        queue.add(event);
        return event;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.schedule.remove(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        long time;
        Queue queue;
        TLongObjectMap<Queue<ScheduledEvent>> requests;
        if (event.phase == TickEvent.Phase.END && (requests = this.schedule.get(event.world)) != null && (queue = (Queue)requests.remove(time = event.world.func_82737_E() - 1L)) != null) {
            for (ScheduledEvent r : queue) {
                event.world.field_72984_F.func_76320_a(r.getClass().getName());
                r.run();
                event.world.field_72984_F.func_76319_b();
            }
        }
    }
}

