/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.utils.EntityUtils;
import pl.asie.charset.lib.utils.Orientation;
import pl.asie.charset.lib.utils.SpaceUtils;

public class ArrowHighlightHandler {
    public static Map<Item, Checker> eligibleItems = new IdentityHashMap<Item, Checker>();
    public static Map<Item, OrientationGetter> orientationGetters = new IdentityHashMap<Item, OrientationGetter>();

    public static boolean defaultChecker(World world, Orientation orientation, ItemStack stack, RayTraceResult trace) {
        return trace.field_178784_b != EnumFacing.UP;
    }

    public static Orientation defaultOrientationGetter(EntityPlayer player, RayTraceResult trace, ItemStack stack) {
        return SpaceUtils.getOrientation(trace.func_178782_a(), (EntityLivingBase)player, trace.field_178784_b, trace.field_72307_f.func_178788_d(new Vec3d((Vec3i)trace.func_178782_a())));
    }

    public static void register(Item ... i) {
        ArrowHighlightHandler.register(ArrowHighlightHandler::defaultChecker, ArrowHighlightHandler::defaultOrientationGetter, i);
    }

    public static void register(Checker check, OrientationGetter getter, Item ... i) {
        if (eligibleItems.isEmpty() && i.length > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new ArrowHighlightHandler());
        }
        for (Item item : i) {
            eligibleItems.put(item, check);
            orientationGetters.put(item, getter);
        }
    }

    private void drawArrowHighlight(EntityPlayer player, RayTraceResult trace, Vec3d cameraPos, ItemStack stack, Checker check, OrientationGetter orientationGetter) {
        Orientation orientation = orientationGetter.get(player, trace, stack);
        if (orientation.top.func_176740_k() == trace.field_178784_b.func_176740_k() || !check.shouldRender(player.func_130014_f_(), orientation, stack, trace)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-cameraPos.field_72450_a), (double)(-cameraPos.field_72448_b), (double)(-cameraPos.field_72449_c));
        EnumFacing fd = trace.field_178784_b;
        BlockPos v = trace.func_178782_a().func_177971_a(fd.func_176730_m());
        GlStateManager.func_179109_b((float)v.func_177958_n(), (float)v.func_177956_o(), (float)v.func_177952_p());
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_187441_d((float)2.0f);
        EnumFacing face = orientation.facing;
        if (SpaceUtils.sign(face) == 1) {
            GlStateManager.func_179109_b((float)face.func_176730_m().func_177958_n(), (float)face.func_176730_m().func_177956_o(), (float)face.func_176730_m().func_177952_p());
        }
        float d = -2.0f;
        GlStateManager.func_179109_b((float)(d * (float)fd.func_176730_m().func_177958_n()), (float)(d * (float)fd.func_176730_m().func_177956_o()), (float)(d * (float)fd.func_176730_m().func_177952_p()));
        GlStateManager.func_179137_b((double)(0.5 * (double)(1 - Math.abs(face.func_176730_m().func_177958_n()))), (double)(0.5 * (double)(1 - Math.abs(face.func_176730_m().func_177956_o()))), (double)(0.5 * (double)(1 - Math.abs(face.func_176730_m().func_177952_p()))));
        GlStateManager.func_187447_r((int)2);
        float mid_x = orientation.facing.func_176730_m().func_177958_n();
        float mid_y = orientation.facing.func_176730_m().func_177956_o();
        float mid_z = orientation.facing.func_176730_m().func_177952_p();
        float top_x = mid_x + (float)orientation.top.func_176730_m().func_177958_n() / 2.0f;
        float top_y = mid_y + (float)orientation.top.func_176730_m().func_177956_o() / 2.0f;
        float top_z = mid_z + (float)orientation.top.func_176730_m().func_177952_p() / 2.0f;
        float bot_x = mid_x - (float)orientation.top.func_176730_m().func_177958_n() / 2.0f;
        float bot_y = mid_y - (float)orientation.top.func_176730_m().func_177956_o() / 2.0f;
        float bot_z = mid_z - (float)orientation.top.func_176730_m().func_177952_p() / 2.0f;
        EnumFacing r = SpaceUtils.rotateCounterclockwise(orientation.facing, orientation.top);
        float right_x = (float)r.func_176730_m().func_177958_n() / 2.0f;
        float right_y = (float)r.func_176730_m().func_177956_o() / 2.0f;
        float right_z = (float)r.func_176730_m().func_177952_p() / 2.0f;
        GlStateManager.func_187435_e((float)top_x, (float)top_y, (float)top_z);
        GlStateManager.func_187435_e((float)(mid_x + right_x), (float)(mid_y + right_y), (float)(mid_z + right_z));
        d = 0.25f;
        GlStateManager.func_187435_e((float)(mid_x + right_x * d), (float)(mid_y + right_y * d), (float)(mid_z + right_z * d));
        GlStateManager.func_187435_e((float)(bot_x + right_x * d), (float)(bot_y + right_y * d), (float)(bot_z + right_z * d));
        d = -0.25f;
        GlStateManager.func_187435_e((float)(bot_x + right_x * d), (float)(bot_y + right_y * d), (float)(bot_z + right_z * d));
        GlStateManager.func_187435_e((float)(mid_x + right_x * d), (float)(mid_y + right_y * d), (float)(mid_z + right_z * d));
        GlStateManager.func_187435_e((float)(mid_x - right_x), (float)(mid_y - right_y), (float)(mid_z - right_z));
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderArrowHighlight(RenderWorldLastEvent event) {
        if (Minecraft.func_71382_s()) {
            RayTraceResult mop;
            ItemStack is;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player != null && !(is = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && eligibleItems.containsKey(is.func_77973_b()) && (mop = mc.field_71476_x) != null && mop.field_72307_f != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                Entity rve = Minecraft.func_71410_x().func_175606_aa();
                if (rve == null) {
                    rve = player;
                }
                this.drawArrowHighlight((EntityPlayer)player, mop, EntityUtils.interpolate(rve, event.getPartialTicks()), is, eligibleItems.get(is.func_77973_b()), orientationGetters.get(is.func_77973_b()));
            }
        }
    }

    @FunctionalInterface
    public static interface OrientationGetter {
        public Orientation get(EntityPlayer var1, RayTraceResult var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface Checker {
        public boolean shouldRender(World var1, Orientation var2, ItemStack var3, RayTraceResult var4);
    }
}

