/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify.component;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentFactory;
import pl.asie.charset.lib.notify.component.NotificationComponentFluidStack;
import pl.asie.charset.lib.notify.component.NotificationComponentItemStack;
import pl.asie.charset.lib.notify.component.NotificationComponentString;
import pl.asie.charset.lib.notify.component.NotificationComponentTextComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentUnknown;

public class NotificationComponentUtil {
    private static final TIntObjectMap<NotificationComponentFactory> factoriesById = new TIntObjectHashMap();
    private static final TObjectIntMap<Class> factoryIdsByClass = new TObjectIntHashMap();
    private static final Map<Class, NotificationComponentFactory> factoriesByClass = new HashMap<Class, NotificationComponentFactory>();

    public static boolean register(int id, NotificationComponentFactory factory) {
        if (factoriesById.containsKey(id)) {
            throw new RuntimeException("NotificationComponentFactory with ID " + id + " already exists!");
        }
        factoriesById.put(id, (Object)factory);
        factoriesByClass.put(factory.getComponentClass(), factory);
        factoryIdsByClass.put(factory.getComponentClass(), id);
        return true;
    }

    public static NotificationComponent deserialize(PacketBuffer buf) {
        int id = buf.func_150792_a();
        if (id != Integer.MIN_VALUE && factoriesById.containsKey(id)) {
            return ((NotificationComponentFactory)factoriesById.get(id)).deserialize(buf);
        }
        return NotificationComponentUnknown.INSTANCE;
    }

    public static void serialize(NotificationComponent component, PacketBuffer buf) {
        NotificationComponentFactory factory = factoriesByClass.get(component.getClass());
        if (factory != null) {
            buf.func_150787_b(factoryIdsByClass.get(component.getClass()));
            factory.serialize(component, buf);
        } else {
            buf.func_150787_b(Integer.MIN_VALUE);
        }
    }

    static {
        NotificationComponentUtil.register(1, new NotificationComponentString.Factory());
        NotificationComponentUtil.register(2, new NotificationComponentTextComponent.Factory());
        NotificationComponentUtil.register(16, new NotificationComponentItemStack.Factory());
        NotificationComponentUtil.register(17, new NotificationComponentFluidStack.Factory());
    }
}

