/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.inventory;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;

public class GuiHandlerCharset
implements IGuiHandler {
    public static final int POCKET_TABLE = 256;
    public static final int KEYRING = 257;
    public static final int CHISEL = 258;
    public static final int RECORD_PLAYER = 259;
    public static final int CHEST = 260;
    public static final int TIMER = 261;
    public static final GuiHandlerCharset INSTANCE = new GuiHandlerCharset();
    private static final TIntObjectMap<Function<Request, Object>> map = new TIntObjectHashMap();

    public void register(int id, Side side, Function<Request, Object> supplier) {
        int rId = id * 2 + (side == Side.CLIENT ? 1 : 0);
        if (map.containsKey(rId)) {
            throw new RuntimeException("GuiHandler ID " + id + "[" + side.name() + "] is taken by " + ((Function)map.get(rId)).getClass().getName() + ", tried to insert " + supplier.getClass().getName() + "!");
        }
        map.put(rId, supplier);
    }

    private GuiHandlerCharset() {
    }

    @Nullable
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Function supplier = (Function)map.get(id * 2);
        return supplier != null ? supplier.apply(new Request(id, player, world, x, y, z)) : null;
    }

    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Function supplier = (Function)map.get(id * 2 + 1);
        return supplier != null ? supplier.apply(new Request(id, player, world, x, y, z)) : null;
    }

    public static final class Request {
        public final EntityPlayer player;
        public final World world;
        public final int x;
        public final int y;
        public final int z;
        private final int id;

        private Request(int id, EntityPlayer player, World world, int x, int y, int z) {
            this.id = id;
            this.player = player;
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public TileEntity getTileEntity() {
            return this.world.func_175625_s(new BlockPos(this.x, this.y, this.z));
        }

        public <T extends Container> T getContainer(Class<T> t) {
            Object o = INSTANCE.getServerGuiElement(this.id, this.player, this.world, this.x, this.y, this.z);
            return (T)((Container)o);
        }
    }
}

