/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import pl.asie.charset.lib.inventory.IContainerHandler;
import pl.asie.charset.lib.utils.ItemUtils;

public abstract class ContainerBase
extends Container {
    protected final List<Slot> SLOTS_PLAYER = new ArrayList<Slot>(36);
    protected final List<Slot> SLOTS_INVENTORY = new ArrayList<Slot>();
    protected final EntityPlayer owner;
    private final IContainerHandler containerHandler;
    int playerInventoryX = -1;
    int playerInventoryY = -1;
    InventoryPlayer playerInventory = null;

    public ContainerBase(InventoryPlayer inventoryPlayer) {
        this(inventoryPlayer, null);
    }

    public ContainerBase(InventoryPlayer inventoryPlayer, IContainerHandler listener) {
        this.owner = inventoryPlayer.field_70458_d;
        this.containerHandler = listener;
        if (listener != null) {
            listener.onOpenedBy(inventoryPlayer.field_70458_d);
        }
    }

    public abstract boolean isOwnerPresent();

    public boolean func_75145_c(EntityPlayer player) {
        return this.isOwnerPresent() && this.containerHandler != null ? this.containerHandler.isUsableByPlayer(player) : this.owner == player;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            this.tryTransferStackInSlot(player, slotObject, slotObject.field_75224_c == player.field_71071_by ? this.SLOTS_INVENTORY : this.SLOTS_PLAYER);
        }
        return ItemStack.field_190927_a;
    }

    private boolean tryInsertStackToSlot(EntityPlayer player, Slot from, Slot to) {
        if (!to.func_75216_d() || ItemUtils.canMerge(from.func_75211_c(), to.func_75211_c())) {
            ItemStack fromStack = from.func_75211_c();
            ItemStack toStack = to.func_75211_c();
            int maxSize = Math.min(toStack.func_77976_d(), to.func_75219_a());
            if (toStack.func_190926_b()) {
                int amount = Math.min(fromStack.func_190916_E(), maxSize);
                if (amount > 0) {
                    to.func_75215_d(fromStack.func_77979_a(amount));
                    return true;
                }
            } else {
                int amount = Math.min(maxSize - toStack.func_190916_E(), fromStack.func_190916_E());
                if (amount > 0) {
                    fromStack.func_190918_g(amount);
                    toStack.func_190917_f(amount);
                    to.func_75215_d(to.func_75211_c());
                    return true;
                }
            }
        }
        return false;
    }

    protected void tryTransferStackInSlot(EntityPlayer player, Slot from, Collection<Slot> targets) {
        boolean dirty = false;
        if (!from.func_75216_d()) {
            return;
        }
        if (from.func_75211_c().func_77985_e()) {
            ArrayList targetsValidEmpty = new ArrayList(targets.size());
            for (Slot to : targets) {
                if (!to.func_75214_a(from.func_75211_c())) continue;
                if (to.func_75216_d()) {
                    dirty |= this.tryInsertStackToSlot(player, from, to);
                    if (from.func_75216_d()) continue;
                    break;
                }
                targetsValidEmpty.add(to);
            }
            if (from.func_75216_d()) {
                Iterator<Object> iterator = targetsValidEmpty.iterator();
                while (iterator.hasNext()) {
                    Slot to;
                    to = (Slot)iterator.next();
                    dirty |= this.tryInsertStackToSlot(player, from, to);
                    if (from.func_75216_d()) continue;
                    break;
                }
            }
        } else {
            for (Slot to : targets) {
                if (!to.func_75214_a(from.func_75211_c()) || to.func_75216_d()) continue;
                dirty |= this.tryInsertStackToSlot(player, from, to);
                if (from.func_75216_d()) continue;
                break;
            }
        }
        ItemStack fromStack = from.func_75211_c();
        if (dirty) {
            if (fromStack.func_190926_b()) {
                fromStack = ItemStack.field_190927_a;
            }
            from.func_75215_d(fromStack);
        }
    }

    public void bindPlayerInventory(InventoryPlayer inventoryPlayer, int startX, int startY) {
        int i;
        this.playerInventoryX = startX;
        this.playerInventoryY = startY;
        this.playerInventory = inventoryPlayer;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, startX + j * 18, startY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, startX + i * 18, startY + 58));
        }
    }

    protected Slot func_75146_a(Slot slotIn) {
        slotIn = super.func_75146_a(slotIn);
        if (slotIn.field_75224_c instanceof InventoryPlayer) {
            this.SLOTS_PLAYER.add(slotIn);
        } else {
            this.SLOTS_INVENTORY.add(slotIn);
        }
        return slotIn;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.containerHandler != null) {
            this.containerHandler.onClosedBy(player);
        }
    }
}

