/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.handlers;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.lib.IFluidExtraInformation;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.lib.utils.UtilProxyCommon;

public class FluidExtraInformationHandler {
    @SideOnly(value=Side.CLIENT)
    public static void addInformation(FluidStack stack, List<String> tooltip, ITooltipFlag flag) {
        if (stack != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (stack.getFluid() instanceof IFluidExtraInformation) {
                ((IFluidExtraInformation)stack.getFluid()).addInformation(stack, (World)world, tooltip, flag);
            }
            if (flag == ITooltipFlag.TooltipFlags.ADVANCED) {
                tooltip.add("");
                tooltip.add(TextFormatting.DARK_GRAY + "Density: " + stack.getFluid().getDensity(stack) + " kg/m^3");
                tooltip.add(TextFormatting.DARK_GRAY + "Temperature: " + stack.getFluid().getTemperature(stack) + " K");
                tooltip.add(TextFormatting.DARK_GRAY + "Viscosity: " + stack.getFluid().getViscosity(stack) + " m/s^2 (x10^-3)");
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        FluidStack contents;
        IFluidTankProperties[] properties;
        IFluidHandlerItem handler;
        ItemStack stack = event.getItemStack();
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (properties = handler.getTankProperties()) != null && properties.length == 1 && properties[0] != null && (contents = properties[0].getContents()) != null) {
            UtilProxyCommon.proxy.addInformation(contents, UtilProxyCommon.proxy.getLocalWorld(), event.getToolTip(), ThreeState.MAYBE);
        }
    }
}

