/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.lib.IBlockCapabilityProvider;

public final class CapabilityHelper {
    protected static final Table<Block, Capability, IBlockCapabilityProvider> blockProviders = HashBasedTable.create();
    private static final Multimap<Capability, Wrapper<?>> wrappers = LinkedListMultimap.create();

    private CapabilityHelper() {
    }

    public static <T> void registerBlockProvider(Capability<T> capability, Block block, IBlockCapabilityProvider<T> provider) {
        if (blockProviders.contains((Object)block, capability)) {
            throw new RuntimeException("CapabilityImpl provider already exists for pair (" + capability.getName() + ", " + block.toString() + ")!");
        }
        blockProviders.put((Object)block, capability, provider);
    }

    public static <T> void registerWrapper(Capability<T> capability, Wrapper<T> provider) {
        wrappers.put(capability, provider);
    }

    public static <T> boolean has(Capability<T> capability, ICapabilityProvider provider, EnumFacing facing) {
        return CapabilityHelper.has(capability, provider, facing, true);
    }

    public static <T> boolean has(Capability<T> capability, ICapabilityProvider provider, EnumFacing facing, boolean withWrappers) {
        if (provider != null) {
            if (provider.hasCapability(capability, facing)) {
                return true;
            }
            if (withWrappers && wrappers.containsKey(capability)) {
                for (Wrapper helper : wrappers.get(capability)) {
                    Object result = helper.get(provider, facing);
                    if (result == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> T get(Capability<T> capability, ICapabilityProvider provider, EnumFacing facing) {
        return CapabilityHelper.get(capability, provider, facing, true);
    }

    public static <T> T get(Capability<T> capability, ICapabilityProvider provider, EnumFacing facing, boolean withWrappers) {
        if (provider != null) {
            if (provider.hasCapability(capability, facing)) {
                return (T)provider.getCapability(capability, facing);
            }
            if (withWrappers && wrappers.containsKey(capability)) {
                for (Wrapper helper : wrappers.get(capability)) {
                    Object result = helper.get(provider, facing);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    public static <T> boolean hasBlockCapability(Capability<T> capability, IBlockState state) {
        return blockProviders.contains((Object)state.func_177230_c(), capability);
    }

    public static <T> T getBlockCapability(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing, Capability<T> capability) {
        Object result;
        IBlockCapabilityProvider provider = (IBlockCapabilityProvider)blockProviders.get((Object)state.func_177230_c(), capability);
        if (provider != null && (result = provider.create(world, pos, state, facing)) != null) {
            return result;
        }
        return null;
    }

    public static <T> boolean has(IBlockAccess world, BlockPos pos, Capability<T> capability, EnumFacing facing, boolean blocks, boolean tiles, boolean entities) {
        IBlockCapabilityProvider provider;
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        if (tiles && state.func_177230_c().hasTileEntity(state) && CapabilityHelper.has(capability, (ICapabilityProvider)(tile = world.func_175625_s(pos)), facing)) {
            return true;
        }
        if (blocks && (provider = (IBlockCapabilityProvider)blockProviders.get((Object)state.func_177230_c(), capability)) != null) {
            return true;
        }
        if (world instanceof World && entities && !world.isSideSolid(pos, facing, false)) {
            List entityList = ((World)world).func_72839_b(null, new AxisAlignedBB(pos));
            for (Entity entity : entityList) {
                if (!CapabilityHelper.has(capability, (ICapabilityProvider)entity, facing)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T get(IBlockAccess world, BlockPos pos, Capability<T> capability, EnumFacing facing, boolean blocks, boolean tiles, boolean entities) {
        IBlockCapabilityProvider provider;
        TileEntity tile;
        T result;
        IBlockState state = world.func_180495_p(pos);
        if (tiles && state.func_177230_c().hasTileEntity(state) && (result = CapabilityHelper.get(capability, (ICapabilityProvider)(tile = world.func_175625_s(pos)), facing)) != null) {
            return result;
        }
        if (blocks && (provider = (IBlockCapabilityProvider)blockProviders.get((Object)state.func_177230_c(), capability)) != null && (result = provider.create(world, pos, state, facing)) != null) {
            return result;
        }
        if (world instanceof World && entities && !world.isSideSolid(pos, facing, false)) {
            List entityList = ((World)world).func_72839_b(null, new AxisAlignedBB(pos));
            for (Entity entity : entityList) {
                T result2 = CapabilityHelper.get(capability, (ICapabilityProvider)entity, facing);
                if (result2 == null) continue;
                return result2;
            }
        }
        return null;
    }

    public static interface Wrapper<T> {
        public T get(ICapabilityProvider var1, EnumFacing var2);
    }
}

