/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.tekkit.tekkit2.fluxcables.common.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.technicpack.tekkit.tekkit2.fluxcables.common.block.BlockFluxCable;

@Mod.EventBusSubscriber(modid="fluxcables")
public class CablesBlocks {
    private static final List<Block> itemBlockRegQueue = new ArrayList<Block>();

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (BlockFluxCable.Type type : BlockFluxCable.Type.VALUES) {
            CablesBlocks.register((IForgeRegistry<Block>)registry, (Block)new BlockFluxCable(type), type.getBlockName());
        }
    }

    private static void register(IForgeRegistry<Block> registry, Block block, String name) {
        block.setRegistryName(name);
        block.func_149663_c("fluxcables:" + name);
        registry.register((IForgeRegistryEntry)block);
        itemBlockRegQueue.add(block);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : itemBlockRegQueue) {
            ItemBlock item = new ItemBlock(block);
            item.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
            registry.register((IForgeRegistryEntry)item);
        }
        itemBlockRegQueue.clear();
    }
}

