/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.tekkit.tekkit2.fluxcables.common.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import tk.zeitheron.cableflux.blocks.BlockPipe;
import tk.zeitheron.cableflux.init.TexturesCF;
import tk.zeitheron.cableflux.pipes.IPipe;
import tk.zeitheron.cableflux.pipes.impl.FEPipe;

public class BlockFluxCable
extends BlockPipe {
    private static final String LANG_TFER_RATE = "fluxcables.tooltip.transfer_rate";
    private static final String TOOLTIP_TFER_RATE = TextFormatting.GRAY + "%s: " + TextFormatting.GREEN + "%d" + TextFormatting.GRAY + " RF/t";
    private final Type type;

    public BlockFluxCable(Type type) {
        super(Material.field_151576_e, type::newPipeInstance);
        this.type = type;
        this.setTexture(type.pipeTexture);
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        tooltip.add(String.format(TOOLTIP_TFER_RATE, I18n.func_74838_a((String)LANG_TFER_RATE), this.type.transferRate));
    }

    public static enum Type {
        LV(256, TexturesCF.FE_1),
        MV(1024, TexturesCF.FE_2),
        HV(4096, TexturesCF.FE_3);

        public static final ImmutableList<Type> VALUES;
        public final int transferRate;
        public final ResourceLocation pipeTexture;
        public final String key;

        private Type(int transferRate, ResourceLocation pipeTexture) {
            this.transferRate = transferRate;
            this.pipeTexture = pipeTexture;
            this.key = this.name().toLowerCase(Locale.ROOT);
        }

        public String getBlockName() {
            return "cable_" + this.key;
        }

        public IPipe newPipeInstance() {
            return new FEPipe(this.pipeTexture, this.transferRate, this.transferRate);
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

