/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.util.math;

import eu.ha3.matmos.core.ReferenceTime;

public class HelperFadeCalculator {
    private final ReferenceTime time;
    private double slope = 0.0;
    private double intercept;
    private float targetFade;
    private boolean doneFading;

    public HelperFadeCalculator(ReferenceTime time) {
        this.time = time;
    }

    public void fadeIn(long durationMs) {
        this.fadeTo(1.0f, durationMs);
    }

    public void fadeOut(long durationMs) {
        this.fadeTo(0.0f, durationMs);
    }

    public void fadeTo(float newVolume, long durationMs) {
        float duration = (float)durationMs / 1000.0f;
        float currentFade = this.calculateFadeFactor();
        this.targetFade = newVolume;
        this.doneFading = false;
        if (currentFade != newVolume) {
            this.slope = (newVolume - currentFade) / duration;
            double now = (double)this.time.getMilliseconds() / 1000.0;
            this.intercept = (double)currentFade - this.slope * now;
        }
    }

    public float calculateFadeFactor() {
        if (this.doneFading) {
            return this.targetFade;
        }
        if (Double.isInfinite(this.slope)) {
            this.doneFading = true;
            return this.targetFade;
        }
        double now = (double)this.time.getMilliseconds() / 1000.0;
        float fadeNow = (float)(this.slope * now + this.intercept);
        if (this.slope > 0.0 && fadeNow > this.targetFade || this.slope < 0.0 && fadeNow < this.targetFade) {
            fadeNow = this.targetFade;
            this.doneFading = true;
        }
        return fadeNow;
    }

    public boolean isDoneFadingOut() {
        return this.doneFading && this.targetFade == 0.0f;
    }

    public float getTargetFade() {
        return this.targetFade;
    }
}

