/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.xpath;

import eu.ha3.matmos.lib.net.sf.practicalxml.xpath.FunctionResolver;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringFunction
extends FunctionResolver.AbstractSelfDescribingFunction {
    protected AbstractStringFunction(String nsUri, String localName) {
        super(new QName(nsUri, localName), 1, 1);
    }

    protected AbstractStringFunction(String nsUri, String localName, int numArgs) {
        super(new QName(nsUri, localName), numArgs, numArgs);
    }

    protected AbstractStringFunction(String nsUri, String localName, int minArgs, int maxArgs) {
        super(new QName(nsUri, localName), minArgs, maxArgs);
    }

    public final Object evaluate(List args) throws XPathFunctionException {
        if (args == null) {
            args = Collections.EMPTY_LIST;
        }
        if (args.size() < this.getMinArgCount() || args.size() > this.getMaxArgCount()) {
            throw new XPathFunctionException("illegal argument count: " + args.size());
        }
        try {
            return this.evaluate(AbstractStringFunction.convertToString(args.get(0)), args);
        }
        catch (Exception e) {
            throw new XPathFunctionException(e);
        }
    }

    public abstract Object evaluate(String var1, List<?> var2);

    protected static String convertToString(Object arg) {
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof NodeList) {
            NodeList nodelist = (NodeList)arg;
            if (nodelist.getLength() == 0) {
                return "";
            }
            return nodelist.item(0).getTextContent();
        }
        if (arg instanceof Double) {
            Double value = (Double)arg;
            double dvalue = value;
            if (value.isNaN()) {
                return "NaN";
            }
            if (dvalue == Double.POSITIVE_INFINITY) {
                return "Infinity";
            }
            if (dvalue == Double.NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            if ((double)value.longValue() == dvalue) {
                return String.valueOf(value.longValue());
            }
            return value.toString();
        }
        if (arg instanceof Number) {
            return arg.toString();
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg != false ? "true" : "false";
        }
        throw new IllegalArgumentException("unsupported argument type: " + arg.getClass().getName());
    }
}

