/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.xpath;

import eu.ha3.matmos.lib.net.sf.practicalxml.xpath.FunctionResolver;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFunction<T>
extends FunctionResolver.AbstractSelfDescribingFunction {
    protected AbstractFunction(String nsUri, String localName) {
        this(nsUri, localName, 0, Integer.MAX_VALUE);
    }

    protected AbstractFunction(String nsUri, String localName, int numArgs) {
        this(nsUri, localName, numArgs, numArgs);
    }

    protected AbstractFunction(String nsUri, String localName, int minArgs, int maxArgs) {
        this(new QName(nsUri, localName), minArgs, maxArgs);
    }

    protected AbstractFunction(QName qname, int minArgs, int maxArgs) {
        super(qname, minArgs, maxArgs);
    }

    public Object evaluate(List args) throws XPathFunctionException {
        if (args == null) {
            args = Collections.EMPTY_LIST;
        }
        if (args.size() < this.getMinArgCount() || args.size() > this.getMaxArgCount()) {
            throw new XPathFunctionException("illegal argument count: " + args.size());
        }
        try {
            T helper = this.init();
            int idx = 0;
            for (Object arg : args) {
                helper = arg instanceof String ? this.processArg(idx, (String)arg, helper) : (arg instanceof Number ? this.processArg(idx, (Number)arg, helper) : (arg instanceof NodeList ? this.processArg(idx, (NodeList)arg, helper) : (arg instanceof Node ? this.processArg(idx, (Node)arg, helper) : (arg == null ? this.processNullArg(idx, helper) : this.processUnexpectedArg(idx, arg, helper)))));
                ++idx;
            }
            return this.getResult(helper);
        }
        catch (Exception e) {
            throw new XPathFunctionException(e);
        }
    }

    protected T init() throws Exception {
        return null;
    }

    protected T processArg(int index, String value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, Number value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, Boolean value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, Node value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, NodeList value, T helper) throws Exception {
        return this.processArg(index, value.item(0), helper);
    }

    protected T processNullArg(int index, T helper) throws Exception {
        throw new IllegalArgumentException("null argument: " + index);
    }

    protected T processUnexpectedArg(int index, Object value, T helper) throws Exception {
        throw new IllegalArgumentException("unexpected argument: " + index + " (" + value.getClass().getName() + ")");
    }

    protected Object getResult(T helper) throws Exception {
        return helper;
    }
}

