/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.junit;

import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.xpath.XPathWrapper;
import java.util.List;
import junit.framework.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomAsserts {
    public static void assertName(String expected, Element elem) {
        Assert.assertEquals((String)expected, (String)DomUtil.getLocalName(elem));
    }

    public static void assertName(String message, String expected, Element elem) {
        Assert.assertEquals((String)message, (String)expected, (String)DomUtil.getLocalName(elem));
    }

    public static void assertNamespaceAndName(String expectedNSUri, String expectedName, Element elem) {
        Assert.assertEquals((String)"invalid namespace", (String)expectedNSUri, (String)elem.getNamespaceURI());
        Assert.assertEquals((String)"invalid localname", (String)expectedName, (String)DomUtil.getLocalName(elem));
    }

    public static void assertNamespaceAndName(String message, String expectedNSUri, String expectedName, Element elem) {
        Assert.assertEquals((String)message, (String)expectedNSUri, (String)elem.getNamespaceURI());
        Assert.assertEquals((String)message, (String)expectedName, (String)DomUtil.getLocalName(elem));
    }

    public static void assertExists(Node node, String xpath) {
        DomAsserts.assertExists(xpath, node, xpath);
    }

    public static void assertExists(String message, Node node, String xpath) {
        DomAsserts.assertExists(message, node, new XPathWrapper(xpath));
    }

    public static void assertExists(Node node, XPathWrapper xpath) {
        DomAsserts.assertExists(xpath.toString(), node, xpath);
    }

    public static void assertExists(String message, Node node, XPathWrapper xpath) {
        List<Node> result = xpath.evaluate(node);
        Assert.assertTrue((String)message, (result.size() > 0 ? 1 : 0) != 0);
    }

    public static void assertNotExists(Node node, String xpath) {
        DomAsserts.assertNotExists(xpath, node, xpath);
    }

    public static void assertNotExists(String message, Node node, String xpath) {
        DomAsserts.assertNotExists(message, node, new XPathWrapper(xpath));
    }

    public static void assertNotExists(Node node, XPathWrapper xpath) {
        DomAsserts.assertNotExists(xpath.toString(), node, xpath);
    }

    public static void assertNotExists(String message, Node node, XPathWrapper xpath) {
        List<Node> result = xpath.evaluate(node);
        Assert.assertTrue((String)message, (result.size() == 0 ? 1 : 0) != 0);
    }

    public static void assertCount(int expected, Node node, String xpath) {
        DomAsserts.assertCount(xpath, expected, node, xpath);
    }

    public static void assertCount(String message, int expected, Node node, String xpath) {
        DomAsserts.assertCount(message, expected, node, new XPathWrapper(xpath));
    }

    public static void assertCount(int expected, Node node, XPathWrapper xpath) {
        DomAsserts.assertCount(xpath.toString(), expected, node, xpath);
    }

    public static void assertCount(String message, int expected, Node node, XPathWrapper xpath) {
        List<Node> result = xpath.evaluate(node);
        Assert.assertEquals((String)message, (int)expected, (int)result.size());
    }

    public static void assertEquals(String expected, Node node, String xpath) {
        DomAsserts.assertEquals(expected, node, new XPathWrapper(xpath));
    }

    public static void assertEquals(String message, String expected, Node node, String xpath) {
        DomAsserts.assertEquals(message, expected, node, new XPathWrapper(xpath));
    }

    public static void assertEquals(String expected, Node node, XPathWrapper xpath) {
        DomAsserts.assertEquals(xpath.toString(), expected, node, xpath);
    }

    public static void assertEquals(String message, String expected, Node node, XPathWrapper xpath) {
        Assert.assertEquals((String)message, (String)expected, (String)xpath.evaluateAsString(node));
    }
}

