/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean;

import eu.ha3.matmos.lib.net.sf.kdgcommons.bean.Introspection;
import eu.ha3.matmos.lib.net.sf.kdgcommons.bean.IntrospectionCache;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.Base64Codec;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.HexCodec;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.XmlUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.ConversionException;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean.Bean2XmlAppenders;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.bean.Bean2XmlOptions;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.ConversionUtils;
import eu.ha3.matmos.lib.net.sf.practicalxml.converter.internal.JavaStringConversions;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean2XmlConverter {
    private EnumSet<Bean2XmlOptions> _options = EnumSet.noneOf(Bean2XmlOptions.class);
    private IntrospectionCache _introspections;
    private JavaStringConversions _converter;
    List<ConversionException> _deferredExceptions;
    private boolean _setAccessible;

    public Bean2XmlConverter(Bean2XmlOptions ... options) {
        for (Bean2XmlOptions option : options) {
            this._options.add(option);
        }
        this._introspections = new IntrospectionCache(this._options.contains((Object)Bean2XmlOptions.CACHE_INTROSPECTIONS));
        this._converter = new JavaStringConversions(this.shouldUseXsdFormatting());
        this._setAccessible = this._options.contains((Object)Bean2XmlOptions.SET_ACCESSIBLE);
    }

    public Element convert(Object obj, String rootName) {
        return this.convert(obj, null, rootName);
    }

    public Element convert(Object obj, String nsUri, String rootName) {
        Element root = DomUtil.newDocument(nsUri, rootName);
        this.doNamespaceHack(root);
        this.convert(obj, rootName, new Bean2XmlAppenders.DirectAppender(this._options, root, obj));
        return root;
    }

    public List<ConversionException> getDeferredExceptions() {
        if (this._deferredExceptions != null) {
            return Collections.unmodifiableList(this._deferredExceptions);
        }
        return Collections.emptyList();
    }

    private void convert(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        block20: {
            try {
                if (obj == null) {
                    this.convertAsNull(null, name, appender);
                } else if (this._converter.isConvertableToString(obj)) {
                    this.convertSimple(obj, name, appender);
                } else if (obj instanceof Enum) {
                    this.convertAsEnum(obj, name, appender);
                } else if (obj instanceof byte[]) {
                    this.convertAsByteArray(obj, name, appender);
                } else if (obj.getClass().isArray()) {
                    this.convertAsArray(obj, name, appender);
                } else if (obj instanceof Map) {
                    this.convertAsMap(obj, name, appender);
                } else if (obj instanceof Collection) {
                    this.convertAsCollection(obj, name, appender);
                } else if (obj instanceof Date) {
                    this.convertAsDate(obj, name, appender);
                } else if (obj instanceof Calendar) {
                    this.convertAsCalendar(obj, name, appender);
                } else {
                    this.convertAsBean(obj, name, appender);
                }
            }
            catch (Exception ex) {
                ConversionException ex2;
                ConversionException conversionException = ex2 = ex instanceof ConversionException ? new ConversionException((ConversionException)ex, name) : new ConversionException("unable to convert", name, (Throwable)ex);
                if (this.exceptionDeferred(ex2)) break block20;
                throw ex2;
            }
        }
    }

    private boolean exceptionDeferred(ConversionException ex) {
        if (!this._options.contains((Object)Bean2XmlOptions.DEFER_EXCEPTIONS)) {
            return false;
        }
        if (this._deferredExceptions == null) {
            this._deferredExceptions = new ArrayList<ConversionException>();
        }
        this._deferredExceptions.add(ex);
        return true;
    }

    private boolean shouldUseXsdFormatting() {
        return this._options.contains((Object)Bean2XmlOptions.XSD_FORMAT) || this._options.contains((Object)Bean2XmlOptions.USE_TYPE_ATTR);
    }

    private void doNamespaceHack(Element root) {
        if (this._options.contains((Object)Bean2XmlOptions.NULL_AS_XSI_NIL)) {
            ConversionUtils.setXsiNil(root, false);
        }
        boolean addCnvNS = this._options.contains((Object)Bean2XmlOptions.USE_INDEX_ATTR);
        addCnvNS |= !this._options.contains((Object)Bean2XmlOptions.MAP_KEYS_AS_ELEMENT_NAME);
        if (addCnvNS &= this._options.contains((Object)Bean2XmlOptions.USE_TYPE_ATTR)) {
            ConversionUtils.setAttribute(root, "ix", "");
        }
    }

    private void convertAsNull(Class<?> klass, String name, Bean2XmlAppenders.Appender appender) {
        appender.appendValue(name, klass, null);
    }

    private void convertSimple(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        appender.appendValue(name, obj.getClass(), this._converter.stringify(obj));
    }

    private void convertAsDate(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        String value = this._options.contains((Object)Bean2XmlOptions.XSD_FORMAT) ? XmlUtil.formatXsdDatetime((Date)obj) : obj.toString();
        appender.appendValue(name, obj.getClass(), value);
    }

    private void convertAsEnum(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        String enumName = ((Enum)obj).name();
        if (this._options.contains((Object)Bean2XmlOptions.ENUM_AS_NAME_AND_VALUE)) {
            Element elem = appender.appendValue(name, obj.getClass(), obj.toString());
            ConversionUtils.setAttribute(elem, "name", enumName);
        } else {
            appender.appendValue(name, obj.getClass(), enumName);
        }
    }

    private void convertAsByteArray(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        if (this._options.contains((Object)Bean2XmlOptions.BYTE_ARRAYS_AS_BASE64)) {
            String value = new Base64Codec().toString((byte[])obj);
            Element child = appender.appendValue(name, obj.getClass(), value);
            appender.overrideType(child, "xsd:base64Binary");
        } else if (this._options.contains((Object)Bean2XmlOptions.BYTE_ARRAYS_AS_HEX)) {
            String value = new HexCodec().toString((byte[])obj);
            Element child = appender.appendValue(name, obj.getClass(), value);
            appender.overrideType(child, "xsd:hexBinary");
        } else {
            this.convertAsArray(obj, name, appender);
        }
    }

    private void convertAsArray(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        String childName = this.determineChildNameForSequence(name);
        Bean2XmlAppenders.Appender childAppender = appender;
        if (!this._options.contains((Object)Bean2XmlOptions.SEQUENCE_AS_REPEATED_ELEMENTS)) {
            Element parent = appender.appendContainer(name, obj.getClass());
            childAppender = new Bean2XmlAppenders.IndexedAppender(appender, parent, obj);
        }
        int length = Array.getLength(obj);
        for (int idx = 0; idx < length; ++idx) {
            Object value = Array.get(obj, idx);
            this.convert(value, childName, childAppender);
        }
    }

    private void convertAsMap(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        Element parent = appender.appendContainer(name, obj.getClass());
        Bean2XmlAppenders.MapAppender childAppender = new Bean2XmlAppenders.MapAppender(appender, parent, obj);
        for (Map.Entry entry : ((Map)obj).entrySet()) {
            this.convert(entry.getValue(), String.valueOf(entry.getKey()), childAppender);
        }
    }

    private void convertAsCollection(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        String childName = this.determineChildNameForSequence(name);
        Bean2XmlAppenders.Appender childAppender = appender;
        if (!this._options.contains((Object)Bean2XmlOptions.SEQUENCE_AS_REPEATED_ELEMENTS)) {
            Element parent = appender.appendContainer(name, obj.getClass());
            childAppender = new Bean2XmlAppenders.IndexedAppender(appender, parent, obj);
        }
        for (Object value : (Collection)obj) {
            this.convert(value, childName, childAppender);
        }
    }

    private void convertAsCalendar(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        Element parent = appender.appendContainer(name, obj.getClass());
        Bean2XmlAppenders.BasicAppender childAppender = new Bean2XmlAppenders.BasicAppender(appender, parent, obj);
        Calendar cal = (Calendar)obj;
        this.convert((Object)cal.getTime(), "date", childAppender);
        this.convert((Object)cal.getTimeZone(), "timezone", childAppender);
        this.convert((Object)cal.getTimeInMillis(), "millis", childAppender);
        this.convert((Object)cal.getFirstDayOfWeek(), "firstDayOfWeek", childAppender);
        this.convert((Object)cal.getMinimalDaysInFirstWeek(), "minimumDaysInFirstWeek", childAppender);
    }

    private void convertAsBean(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        Element parent = appender.appendContainer(name, obj.getClass());
        Bean2XmlAppenders.BasicAppender childAppender = new Bean2XmlAppenders.BasicAppender(appender, parent, obj);
        Introspection ispec = this._introspections.lookup(obj.getClass(), this._setAccessible);
        for (String propName : ispec.propertyNames()) {
            this.convertBeanProperty(obj, ispec, propName, childAppender);
        }
    }

    private void convertBeanProperty(Object bean, Introspection ispec, String propName, Bean2XmlAppenders.Appender appender) {
        block5: {
            try {
                Object value;
                Method getter = ispec.getter(propName);
                Object object = value = getter != null ? getter.invoke(bean, new Object[0]) : null;
                if (value == null) {
                    this.convertAsNull(ispec.type(propName), propName, appender);
                } else {
                    if (appender.shouldSkip(value)) {
                        return;
                    }
                    this.convert(value, propName, appender);
                }
            }
            catch (Exception ex) {
                ConversionException ex2;
                ConversionException conversionException = ex2 = ex instanceof ConversionException ? new ConversionException((ConversionException)ex, propName) : new ConversionException("unable to retrieve bean property", propName, (Throwable)ex);
                if (this.exceptionDeferred(ex2)) break block5;
                throw ex2;
            }
        }
    }

    private String determineChildNameForSequence(String parentName) {
        if (StringUtil.isEmpty(parentName)) {
            return "data";
        }
        if (this._options.contains((Object)Bean2XmlOptions.SEQUENCE_AS_REPEATED_ELEMENTS)) {
            return parentName;
        }
        if (!this._options.contains((Object)Bean2XmlOptions.SEQUENCE_NAMED_BY_PARENT)) {
            return "data";
        }
        if (parentName.endsWith("s") || parentName.endsWith("S")) {
            return parentName.substring(0, parentName.length() - 1);
        }
        return parentName;
    }
}

