/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml.converter;

import eu.ha3.matmos.lib.net.sf.practicalxml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionConverter {
    public static Document convertToXml(Map<String, ?> map, String rootName, String ... keyFilter) {
        Element root = DomUtil.newDocument(rootName);
        CollectionConverter.appendElements(map, root, CollectionConverter.digestFilter(keyFilter));
        return root.getOwnerDocument();
    }

    public static Document convertToXml(Map<String, ?> map, QName rootName, String ... keyFilter) {
        Element root = DomUtil.newDocument(rootName);
        CollectionConverter.appendElements(map, root, CollectionConverter.digestFilter(keyFilter));
        return root.getOwnerDocument();
    }

    public static Map<String, ?> convertToMap(Element elem, String ... keyFilter) {
        return CollectionConverter.convertToMap(elem, CollectionConverter.digestFilter(keyFilter));
    }

    public static List<Map<String, ?>> convertToMap(List<Element> elems, String ... keyFilter) {
        ArrayList result = new ArrayList(elems.size());
        Set<String> filter = CollectionConverter.digestFilter(keyFilter);
        for (Element elem : elems) {
            result.add(CollectionConverter.convertToMap(elem, filter));
        }
        return result;
    }

    private static Set<String> digestFilter(String ... keyFilter) {
        if (keyFilter.length == 0) {
            return null;
        }
        HashSet<String> filter = new HashSet<String>();
        for (String key : keyFilter) {
            filter.add(key);
        }
        return filter;
    }

    public static Map<String, ?> convertToMap(Element elem, Set<String> keyFilter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Element child : DomUtil.getChildren(elem)) {
            CollectionConverter.appendChild(result, child, keyFilter);
        }
        return result;
    }

    private static void appendChild(Map<String, Object> map, Element child, Set<String> keyFilter) {
        String key = DomUtil.getLocalName(child);
        if (keyFilter != null && !keyFilter.contains(key)) {
            return;
        }
        Object value = CollectionConverter.getChildValue(child, keyFilter);
        if (!map.containsKey(key)) {
            map.put(key, value);
            return;
        }
        Object current = map.get(key);
        if (current instanceof List) {
            List list = (List)current;
            list.add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(current);
            list.add(value);
            map.put(key, list);
        }
    }

    private static Object getChildValue(Element child, Set<String> keyFilter) {
        if (DomUtil.hasElementChildren(child)) {
            return CollectionConverter.convertToMap(child, keyFilter);
        }
        return DomUtil.getText(child);
    }

    private static void appendElements(Map<String, ?> map, Element parent, Set<String> keyFilter) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            if (keyFilter != null && !keyFilter.contains(key)) continue;
            Object value = entry.getValue();
            CollectionConverter.appendElement(parent, key, value, keyFilter);
        }
    }

    private static void appendElement(Element parent, String key, Object value, Set<String> keyFilter) {
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            if (value != null) break block2;
                            DomUtil.appendChildInheritNamespace(parent, key);
                            break block3;
                        }
                        if (!(value instanceof String)) break block4;
                        Element child = DomUtil.appendChildInheritNamespace(parent, key);
                        DomUtil.setText(child, (String)value);
                        break block3;
                    }
                    if (!(value instanceof Map)) break block5;
                    Element child = DomUtil.appendChildInheritNamespace(parent, key);
                    CollectionConverter.appendElements((Map)value, child, keyFilter);
                    break block3;
                }
                if (!(value instanceof Collection)) break block6;
                for (Object obj : (Collection)value) {
                    CollectionConverter.appendElement(parent, key, obj, keyFilter);
                }
                break block3;
            }
            if (!value.getClass().isArray()) break block3;
            for (Object obj : (Object[])value) {
                CollectionConverter.appendElement(parent, key, obj, keyFilter);
            }
        }
    }
}

