/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.practicalxml;

import eu.ha3.matmos.lib.net.sf.kdgcommons.io.IOUtil;
import eu.ha3.matmos.lib.net.sf.practicalxml.XmlException;
import eu.ha3.matmos.lib.net.sf.practicalxml.util.ExceptionErrorHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseUtil {
    public static Document parse(InputSource source, ErrorHandler errHandler) {
        DocumentBuilder db = ParseUtil.newNVDocumentBuilder();
        if (errHandler != null) {
            db.setErrorHandler(errHandler);
        }
        try {
            return db.parse(source);
        }
        catch (IOException e) {
            throw new XmlException("unable to parse", e);
        }
        catch (SAXException e) {
            throw new XmlException("unable to parse", e);
        }
    }

    public static Document parse(InputSource source) {
        return ParseUtil.parse(source, new ExceptionErrorHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputStream in) {
        try {
            Document document = ParseUtil.parse(new InputSource(new BufferedInputStream(in)));
            return document;
        }
        finally {
            IOUtil.closeQuietly(in);
        }
    }

    public static Document parse(String xml) {
        return ParseUtil.parse(new InputSource(new StringReader(xml)));
    }

    public static Document parse(File file) {
        try {
            return ParseUtil.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new XmlException("file not found: " + file, ex);
        }
    }

    public static Document validatingParse(InputSource source, EntityResolver resolver, ErrorHandler errHandler) {
        DocumentBuilder db = ParseUtil.newDTDDocumentBuilder();
        if (resolver != null) {
            db.setEntityResolver(resolver);
        }
        if (errHandler != null) {
            db.setErrorHandler(errHandler);
        }
        try {
            return db.parse(source);
        }
        catch (IOException e) {
            throw new XmlException("unable to parse", e);
        }
        catch (SAXException e) {
            throw new XmlException("unable to parse", e);
        }
    }

    public static Document validatingParse(InputSource source, ErrorHandler errHandler) {
        return ParseUtil.validatingParse(source, (EntityResolver)null, errHandler);
    }

    public static Document validatingParse(InputSource source, Schema schema, ErrorHandler errHandler) {
        DocumentBuilder db = ParseUtil.newXSDDocumentBuilder(schema);
        if (errHandler != null) {
            db.setErrorHandler(errHandler);
        }
        try {
            return db.parse(source);
        }
        catch (IOException e) {
            throw new XmlException("unable to parse", e);
        }
        catch (SAXException e) {
            throw new XmlException("unable to parse", e);
        }
    }

    public static Document parseFromClasspath(String resourcePath) {
        return ParseUtil.parseFromClasspath(resourcePath, new ExceptionErrorHandler());
    }

    public static Document parseFromClasspath(String resourcePath, ErrorHandler errorHandler) {
        return ParseUtil.parseFromClasspath(Thread.currentThread().getContextClassLoader(), resourcePath, errorHandler);
    }

    public static Document parseFromClasspath(String resourcePath, Class<?> klass) {
        return ParseUtil.parseFromClasspath(resourcePath, new ExceptionErrorHandler());
    }

    public static Document parseFromClasspath(String resourcePath, Class<?> klass, ErrorHandler errorHandler) {
        return ParseUtil.parseFromClasspath(klass.getClassLoader(), resourcePath, errorHandler);
    }

    private static synchronized DocumentBuilder newNVDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to confiure parser", e);
        }
    }

    private static synchronized DocumentBuilder newDTDDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to confiure parser", e);
        }
    }

    private static synchronized DocumentBuilder newXSDDocumentBuilder(Schema schema) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        dbf.setSchema(schema);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to configure parser", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseFromClasspath(ClassLoader classloader, String resourcePath, ErrorHandler errorHandler) {
        InputStream in = null;
        try {
            in = classloader.getResourceAsStream(resourcePath);
            Document document = ParseUtil.parse(new InputSource(in), errorHandler);
            return document;
        }
        finally {
            IOUtil.closeQuietly(in);
        }
    }
}

