/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class FormatUtil {
    private static String localZone = TimeZone.getDefault().getID();
    private static Map<String, Map<String, ThreadLocal<SimpleDateFormat>>> tzDateFormatters = new ConcurrentHashMap<String, Map<String, ThreadLocal<SimpleDateFormat>>>();
    private static Map<String, ThreadLocal<DecimalFormat>> decimalFormatters = new ConcurrentHashMap<String, ThreadLocal<DecimalFormat>>();

    public static String formatDate(Date date, String format) {
        return FormatUtil.formatDate(date, format, localZone);
    }

    public static String formatDate(Date date, String format, String zoneId) {
        return FormatUtil.getDateFormatter(format, zoneId).format(date);
    }

    public static String formatDate(Calendar cal, String format) {
        return FormatUtil.formatDate(cal.getTime(), format, localZone);
    }

    public static String formatDate(Calendar cal, String format, String zoneId) {
        return FormatUtil.getDateFormatter(format, zoneId).format(cal.getTime());
    }

    public static String formatDate(long time, String format) {
        return FormatUtil.formatDate(new Date(time), format, localZone);
    }

    public static String formatDate(long time, String format, String zoneId) {
        return FormatUtil.getDateFormatter(format, zoneId).format(new Date(time));
    }

    public static String formatNumber(Number value, String format) {
        return FormatUtil.getNumberFormatter(format).format(value);
    }

    private static SimpleDateFormat getDateFormatter(final String format, final String zoneId) {
        ThreadLocal<SimpleDateFormat> threadLocal;
        Map<String, ThreadLocal<SimpleDateFormat>> zoneFormatters = tzDateFormatters.get(zoneId);
        if (zoneFormatters == null) {
            zoneFormatters = new ConcurrentHashMap<String, ThreadLocal<SimpleDateFormat>>();
            tzDateFormatters.put(zoneId, zoneFormatters);
        }
        if ((threadLocal = zoneFormatters.get(format)) == null) {
            threadLocal = new ThreadLocal<SimpleDateFormat>(){

                @Override
                protected SimpleDateFormat initialValue() {
                    SimpleDateFormat formatter = new SimpleDateFormat(format);
                    formatter.setTimeZone(TimeZone.getTimeZone(zoneId));
                    return formatter;
                }
            };
            zoneFormatters.put(format, threadLocal);
        }
        return threadLocal.get();
    }

    private static DecimalFormat getNumberFormatter(final String format) {
        ThreadLocal<DecimalFormat> threadLocal = decimalFormatters.get(format);
        if (threadLocal == null) {
            threadLocal = new ThreadLocal<DecimalFormat>(){

                @Override
                protected DecimalFormat initialValue() {
                    return new DecimalFormat(format);
                }
            };
            decimalFormatters.put(format, threadLocal);
        }
        return threadLocal.get();
    }
}

