/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters<K>
implements Map<K, Long>,
Iterable<Map.Entry<K, Long>> {
    private ConcurrentHashMap<K, AtomicLong> _map = new ConcurrentHashMap();

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        long test = ((Number)value).longValue();
        for (AtomicLong entry : this._map.values()) {
            if (test != entry.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        AtomicLong value = this._map.get(key);
        return this.translate(value);
    }

    @Override
    public Long put(K key, Long newValue) {
        AtomicLong value = this._map.get(key);
        Long oldValue = this.translate(value);
        if (value == null) {
            this._map.put(key, new AtomicLong(newValue));
        } else {
            value.set(newValue);
        }
        return oldValue;
    }

    @Override
    public Long remove(Object key) {
        AtomicLong oldValue = this._map.remove(key);
        return this.translate(oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Long> map) {
        for (Map.Entry<K, Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._map.keySet();
    }

    @Override
    public Collection<Long> values() {
        ArrayList<Long> result = new ArrayList<Long>(this._map.size());
        for (AtomicLong value : this._map.values()) {
            result.add(value.get());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, Long>> entrySet() {
        HashSet<Map.Entry<K, Long>> entries = new HashSet<Map.Entry<K, Long>>();
        for (Map.Entry<K, Long> entry : this) {
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public Long putIfAbsent(K key, Long value) {
        AtomicLong oldValue = this._map.get(key);
        if (oldValue == null) {
            oldValue = this._map.putIfAbsent(key, new AtomicLong(value));
        }
        return this.translate(oldValue);
    }

    public long getLong(K key) {
        AtomicLong mapping = this._map.get(key);
        return mapping == null ? 0L : mapping.get();
    }

    public void putLong(K key, long value) {
        this.put(key, value);
    }

    public long increment(K key) {
        AtomicLong counter = this.getOrCreate(key);
        return counter.incrementAndGet();
    }

    public long decrement(K key) {
        AtomicLong counter = this.getOrCreate(key);
        return counter.decrementAndGet();
    }

    @Override
    public Iterator<Map.Entry<K, Long>> iterator() {
        return new MyIterator(this._map.entrySet().iterator());
    }

    private Long translate(AtomicLong value) {
        return value == null ? null : Long.valueOf(value.get());
    }

    private AtomicLong getOrCreate(K key) {
        AtomicLong value = this._map.get(key);
        if (value != null) {
            return value;
        }
        this._map.putIfAbsent(key, new AtomicLong());
        return this._map.get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyMapEntry
    implements Map.Entry<K, Long> {
        private K _key;
        private AtomicLong _value;

        public MyMapEntry(K key, AtomicLong value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public Long getValue() {
            return this._value.longValue();
        }

        @Override
        public Long setValue(Long value) {
            long oldValue = this._value.getAndSet(value);
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<Map.Entry<K, Long>> {
        private Iterator<Map.Entry<K, AtomicLong>> _baseItx;

        public MyIterator(Iterator<Map.Entry<K, AtomicLong>> baseItx) {
            this._baseItx = baseItx;
        }

        @Override
        public boolean hasNext() {
            return this._baseItx.hasNext();
        }

        @Override
        public Map.Entry<K, Long> next() {
            Map.Entry next = this._baseItx.next();
            return new MyMapEntry(next.getKey(), next.getValue());
        }

        @Override
        public void remove() {
            this._baseItx.remove();
        }
    }
}

