/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.test;

import java.util.regex.Pattern;
import junit.framework.Assert;

public class StringAsserts {
    public static void assertSubstringCount(String str, String sub, int expected) {
        StringAsserts.assertSubstringCount("", str, sub, expected);
    }

    public static void assertSubstringCount(String message, String str, String sub, int expected) {
        int actual = 0;
        int idx = str.indexOf(sub);
        while (idx >= 0 && idx < str.length()) {
            actual += idx >= 0 ? 1 : 0;
            idx = str.indexOf(sub, idx + 1);
        }
        Assert.assertEquals((String)(message + ": count(" + sub + ")"), (int)expected, (int)actual);
    }

    public static void assertRegex(String regex, String actual) {
        StringAsserts.assertRegex("expected: " + regex + ", was: " + actual, regex, actual);
    }

    public static void assertRegex(String message, String regex, String actual) {
        Assert.assertTrue((String)message, (boolean)Pattern.matches(regex, actual));
    }

    public static void assertContainsRegex(String regex, String str) {
        StringAsserts.assertContainsRegex("expected: " + regex + ", was: " + str, regex, str);
    }

    public static void assertContainsRegex(String message, String regex, String str) {
        Assert.assertTrue((String)message, (boolean)Pattern.compile(regex).matcher(str).find());
    }

    public static void assertDoesntContainRegex(String regex, String str) {
        StringAsserts.assertDoesntContainRegex("didn't expact: " + regex + ", was: " + str, regex, str);
    }

    public static void assertDoesntContainRegex(String message, String regex, String str) {
        Assert.assertFalse((String)message, (boolean)Pattern.compile(regex).matcher(str).find());
    }

    public static String assertContainsThenRemove(String src, String expected) {
        int idx = src.indexOf(expected);
        if (idx < 0) {
            Assert.fail((String)("\"" + expected + "\" not found: " + src));
        }
        int idx2 = idx + expected.length();
        return src.substring(0, idx) + src.substring(idx2);
    }
}

