/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.lang;

import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.NumberUtil;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringCanon;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class StringUtil {
    private static StringCanon _canon = new StringCanon();
    private static Random _RNG = new Random(System.currentTimeMillis());

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static boolean equalOrEmpty(String s1, String s2) {
        s1 = s1 == null ? "" : s1;
        s2 = s2 == null ? "" : s2;
        return s1.equals(s2);
    }

    public static char lastChar(String str) {
        int index = str != null ? str.length() - 1 : -1;
        return index < 0 ? (char)'\u0000' : str.charAt(index);
    }

    public static boolean isEmpty(String str) {
        return StringUtil.length(str) == 0;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            str = "";
        }
        for (int ii = 0; ii < str.length(); ++ii) {
            if (Character.isWhitespace(str.charAt(ii))) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() == 0) {
            return "";
        }
        if (!Character.isWhitespace(str.charAt(0)) && !Character.isWhitespace(str.charAt(str.length() - 1))) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimToNull(String str) {
        return (str = StringUtil.trim(str)).length() == 0 ? null : str;
    }

    public static String padLeft(String str, int len, char c) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= len) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int ii = len - str.length(); ii > 0; --ii) {
            sb.append(c);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padRight(String str, int len, char c) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= len) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(str);
        while (sb.length() < len) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean contains(String str, String segment) {
        if (str == null || segment == null) {
            return false;
        }
        if (segment.length() == 0) {
            return true;
        }
        return str.indexOf(segment) >= 0;
    }

    public static boolean containsIgnoreCase(String str, String segment) {
        if (str == null || segment == null) {
            return false;
        }
        return StringUtil.contains(str.toUpperCase(), segment.toUpperCase());
    }

    public static String repeat(char c, int count) {
        char[] chars = new char[count];
        for (int ii = 0; ii < count; ++ii) {
            chars[ii] = c;
        }
        return new String(chars);
    }

    public static byte[] toUTF8(String str) {
        try {
            if (str == null) {
                return new byte[0];
            }
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported", e);
        }
    }

    public static String fromUTF8(byte[] bytes) {
        try {
            if (bytes == null) {
                return "";
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported", e);
        }
    }

    public static String unicodeEscape(String src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src);
        for (int ii = 0; ii < sb.length(); ++ii) {
            char c = sb.charAt(ii);
            if (c >= ' ' && c <= '~' && c != '\\' && c != '\'' && c != '\"') continue;
            sb.deleteCharAt(ii);
            sb.insert(ii, NumberUtil.toHexString(c, 4));
            sb.insert(ii, "\\u");
            ii += 5;
        }
        return sb.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(src);
        for (int ii = 0; ii < sb.length(); ++ii) {
            if (sb.charAt(ii) != '\\') continue;
            sb.deleteCharAt(ii);
            if (sb.charAt(ii) == 'u' || sb.charAt(ii) == 'U') {
                int c = (StringUtil.hex2dec(sb.charAt(ii + 1)) << 12) + (StringUtil.hex2dec(sb.charAt(ii + 2)) << 8) + (StringUtil.hex2dec(sb.charAt(ii + 3)) << 4) + StringUtil.hex2dec(sb.charAt(ii + 4));
                sb.setCharAt(ii, (char)c);
                sb.delete(ii + 1, ii + 5);
                continue;
            }
            if (sb.charAt(ii) == 'b') {
                sb.setCharAt(ii, '\b');
                continue;
            }
            if (sb.charAt(ii) == 't') {
                sb.setCharAt(ii, '\t');
                continue;
            }
            if (sb.charAt(ii) == 'n') {
                sb.setCharAt(ii, '\n');
                continue;
            }
            if (sb.charAt(ii) == 'f') {
                sb.setCharAt(ii, '\f');
                continue;
            }
            if (sb.charAt(ii) != 'r') continue;
            sb.setCharAt(ii, '\r');
        }
        return sb.toString();
    }

    public static int parseDigit(char c, int base) {
        int value = -1;
        if (c >= '0' && c <= '9') {
            value = c - 48;
        } else if (c >= 'a' && c <= 'z') {
            value = c - 97 + 10;
        } else if (c >= 'A' && c <= 'Z') {
            value = c - 65 + 10;
        }
        if (value >= base) {
            value = -1;
        }
        return value;
    }

    public static String intern(String str) {
        return _canon.intern(str);
    }

    public static String randomString(String chars, int minLength, int maxLength) {
        StringBuilder sb = new StringBuilder(maxLength);
        int len = minLength + _RNG.nextInt(maxLength - minLength + 1);
        for (int ii = 0; ii < len; ++ii) {
            sb.append(chars.charAt(_RNG.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static String randomAlphaString(int minLength, int maxLength) {
        return StringUtil.randomString("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", minLength, maxLength);
    }

    public static String extractLeft(String source, String target) {
        if (source == null) {
            source = "";
        }
        if (target == null) {
            target = "";
        }
        if (target.length() == 0) {
            return source;
        }
        int idx = source.indexOf(target);
        if (idx < 0) {
            return source;
        }
        return source.substring(0, idx);
    }

    public static String extractRight(String source, String target) {
        if (source == null) {
            source = "";
        }
        if (target == null) {
            target = "";
        }
        if (target.length() == 0) {
            return "";
        }
        int idx = source.indexOf(target);
        if (idx < 0) {
            return "";
        }
        return source.substring(idx + target.length());
    }

    public static String extractLeftOfLast(String source, String target) {
        if (source == null) {
            source = "";
        }
        if (target == null) {
            target = "";
        }
        if (target.length() == 0) {
            return source;
        }
        int idx = source.lastIndexOf(target);
        if (idx < 0) {
            return source;
        }
        return source.substring(0, idx);
    }

    public static String extractRightOfLast(String source, String target) {
        if (source == null) {
            source = "";
        }
        if (target == null) {
            target = "";
        }
        if (target.length() == 0) {
            return "";
        }
        int idx = source.lastIndexOf(target);
        if (idx < 0) {
            return "";
        }
        return source.substring(idx + target.length());
    }

    public static boolean isIn(String str, String ... targets) {
        for (String target : targets) {
            if (str == null && target == null) {
                return true;
            }
            if (str == null || !str.equals(target)) continue;
            return true;
        }
        return false;
    }

    public static String valueOf(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private static int hex2dec(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("not a hex digit: " + c);
    }
}

