/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.lang;

public class StringBuilderUtil {
    private static final char[] NIBBLES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static StringBuilder appendRepeat(StringBuilder buf, char c, int count) {
        buf.ensureCapacity(buf.length() + count);
        for (int ii = 0; ii < count; ++ii) {
            buf.append(c);
        }
        return buf;
    }

    public static StringBuilder appendHex(StringBuilder buf, int value, int width) {
        StringBuilderUtil.appendRepeat(buf, '0', width);
        int offset = buf.length();
        for (int ii = 1; ii <= width; ++ii) {
            int nibble = value & 0xF;
            buf.setCharAt(offset - ii, NIBBLES[nibble]);
            value >>>= 4;
        }
        return buf;
    }

    public static char lastChar(StringBuilder buf) {
        int index = buf != null ? buf.length() - 1 : -1;
        return index < 0 ? (char)'\u0000' : buf.charAt(index);
    }

    public static StringBuilder appendUnless(StringBuilder sb, String test, String str) {
        int idx = sb.length() - test.length();
        if (idx < 0) {
            sb.append(str);
            return sb;
        }
        for (int ii = 0; ii < test.length(); ++ii) {
            if (sb.charAt(idx + ii) == test.charAt(ii)) continue;
            sb.append(str);
            return sb;
        }
        return sb;
    }
}

