/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;

public class MonitoredInputStream
extends InputStream {
    private InputStream _delegate;
    private long _totalBytes;

    public MonitoredInputStream(InputStream delegate) {
        this._delegate = delegate;
    }

    public int available() throws IOException {
        return this._delegate.available();
    }

    public void close() throws IOException {
        this._delegate.close();
    }

    public int read() throws IOException {
        int b = this._delegate.read();
        long bytesRead = b < 0 ? 0L : 1L;
        this._totalBytes += bytesRead;
        this.progress(bytesRead, this._totalBytes);
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = this._delegate.read(b, off, len);
        long bytesRead = count < 0 ? 0L : (long)count;
        this._totalBytes += bytesRead;
        this.progress(bytesRead, this._totalBytes);
        return count;
    }

    public boolean markSupported() {
        return this._delegate.markSupported();
    }

    public synchronized void mark(int readlimit) {
        this._delegate.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this._delegate.reset();
    }

    public long skip(long n) throws IOException {
        long skipped = this._delegate.skip(n);
        this._totalBytes += skipped;
        this.progress(skipped, this._totalBytes);
        return skipped;
    }

    public void progress(long lastRead, long totalBytes) {
    }
}

