/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;

public class CombiningInputStream
extends InputStream {
    private InputStream[] _constituents;
    private int _current;
    private int _marked = -1;
    private int _markLimit = -1;

    public CombiningInputStream(InputStream ... constituents) {
        this._constituents = constituents;
    }

    private boolean isEOF() {
        return this._current == this._constituents.length;
    }

    private boolean switchStreams() {
        ++this._current;
        if (!this.isEOF() && this._markLimit > 0) {
            this.getCurrent().mark(this._markLimit);
        }
        return this.isEOF();
    }

    private InputStream getCurrent() {
        return this.isEOF() ? null : this._constituents[this._current];
    }

    public int available() throws IOException {
        return this.isEOF() ? 0 : this.getCurrent().available();
    }

    public void close() throws IOException {
        IOException thrown = null;
        for (int ii = 0; ii < this._constituents.length; ++ii) {
            try {
                this._constituents[ii].close();
                continue;
            }
            catch (IOException e) {
                thrown = e;
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        int i = this.getCurrent().read();
        if (i < 0) {
            this.switchStreams();
            return this.read();
        }
        --this._markLimit;
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        int total = 0;
        while (len > 0) {
            int read = this.getCurrent().read(b, off, len);
            if (read < 0) {
                if (!this.switchStreams() && this.getCurrent().available() != 0) continue;
                break;
            }
            total += read;
            off += read;
            len -= read;
            this._markLimit -= read;
        }
        return total;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public boolean markSupported() {
        boolean supported = true;
        for (int ii = this._current; ii < this._constituents.length; ++ii) {
            supported &= this._constituents[ii].markSupported();
        }
        return supported;
    }

    public void mark(int readlimit) {
        if (!this.isEOF()) {
            this._marked = this._current;
            this._markLimit = readlimit;
            this.getCurrent().mark(readlimit);
        }
    }

    public void reset() throws IOException {
        if (this._marked < 0) {
            throw new IOException("no mark set");
        }
        if (this.isEOF()) {
            --this._current;
        }
        while (this._current > this._marked) {
            this.getCurrent().reset();
            --this._current;
        }
        this.getCurrent().reset();
    }

    public long skip(long n) throws IOException {
        if (this.isEOF()) {
            return -1L;
        }
        long total = 0L;
        while (n > 0L && !this.isEOF()) {
            long bytes = this.getCurrent().skip(n);
            if (bytes <= 0L) {
                int check = this.read();
                if (check < 0) break;
                bytes = 1L;
            }
            total += bytes;
            n -= bytes;
        }
        return total;
    }
}

