/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;

public class BOMExclusionInputStream
extends InputStream {
    private InputStream _delegate;
    private int[] _firstBytes;
    private int _fbLen;
    private int _fbIndex;
    private boolean _markedAtStart;

    public BOMExclusionInputStream(InputStream delegate) {
        this._delegate = delegate;
    }

    private int readFirstBytes() throws IOException {
        if (this._firstBytes == null) {
            this._firstBytes = new int[3];
            int b0 = this._delegate.read();
            if (b0 < 0 || b0 != 239) {
                return b0;
            }
            int b1 = this._delegate.read();
            int b2 = this._delegate.read();
            if (b1 == 187 && b2 == 191) {
                return this._delegate.read();
            }
            this._firstBytes[this._fbLen++] = b0;
            this._firstBytes[this._fbLen++] = b1;
            this._firstBytes[this._fbLen++] = b2;
        }
        return this._fbIndex < this._fbLen ? this._firstBytes[this._fbIndex++] : -1;
    }

    public int available() throws IOException {
        return this._delegate.available();
    }

    public void close() throws IOException {
        this._delegate.close();
    }

    public int read() throws IOException {
        int b = this.readFirstBytes();
        return b >= 0 ? b : this._delegate.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int firstCount = 0;
        int b = 0;
        while (len > 0 && b >= 0) {
            b = this.readFirstBytes();
            if (b < 0) continue;
            buf[off++] = (byte)(b & 0xFF);
            --len;
            ++firstCount;
        }
        int secondCount = this._delegate.read(buf, off, len);
        return secondCount < 0 ? firstCount : firstCount + secondCount;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public boolean markSupported() {
        return this._delegate.markSupported();
    }

    public synchronized void mark(int readlimit) {
        this._markedAtStart = this._firstBytes == null;
        this._delegate.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        if (this._markedAtStart) {
            this._firstBytes = null;
        }
        this._delegate.reset();
    }

    public long skip(long n) throws IOException {
        while (n > 0L && this.readFirstBytes() >= 0) {
            --n;
        }
        return this._delegate.skip(n);
    }
}

