/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.html;

import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUtil {
    private static Map<String, Character> entityLookup = new HashMap<String, Character>();

    public static String urlEncode(String src) {
        if (src == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(src, "UTF-8");
            if (encoded.indexOf(43) >= 0) {
                encoded = encoded.replace("+", "%20");
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("this JVM doesn't support UTF-8!", e);
        }
    }

    public static String urlDecode(String src) {
        if (src == null) {
            return "";
        }
        try {
            return URLDecoder.decode(src, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("this JVM doesn't support UTF-8!", e);
        }
    }

    public static String escape(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(src.length() * 5 / 4);
        block7: for (int ii = 0; ii < src.length(); ++ii) {
            char c = src.charAt(ii);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    if (c < '\u0080') {
                        sb.append(c);
                        continue block7;
                    }
                    sb.append("&#x").append(Integer.toString(c, 16).toLowerCase()).append(";");
                }
            }
        }
        return sb.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return "";
        }
        if (src.indexOf(38) < 0) {
            return src;
        }
        StringBuilder sb = new StringBuilder(src.length());
        int ii = 0;
        while (ii < src.length()) {
            int kk;
            int jj = src.indexOf(38, ii);
            int n = kk = jj < 0 ? -1 : src.indexOf(59, jj);
            if (jj < 0 || kk < 0) {
                sb.append(src.substring(ii));
                break;
            }
            sb.append(src.substring(ii, jj));
            String entity = src.substring(jj + 1, kk);
            if (entityLookup.containsKey(entity)) {
                sb.append(entityLookup.get(entity).charValue());
            } else if (entity.length() > 1 && entity.charAt(0) == '#') {
                int radix = 10;
                if ((entity = entity.substring(1)).charAt(0) == 'x' || entity.charAt(0) == 'X') {
                    entity = entity.substring(1);
                    radix = 16;
                }
                char c = (char)(Integer.parseInt(entity, radix) & 0xFFFF);
                sb.append(c);
            } else {
                sb.append('&').append(entity).append(';');
            }
            ii = kk + 1;
        }
        return sb.toString();
    }

    public static void appendAttribute(StringBuilder buf, String name, Object value) {
        value = value == null ? "" : value;
        buf.append(" ").append(name).append("='").append(HtmlUtil.escape(value.toString())).append("'");
    }

    public static void appendOptionalAttribute(StringBuilder buf, String name, Object value) {
        if (value == null) {
            return;
        }
        String sValue = value.toString();
        if (sValue.length() > 0) {
            HtmlUtil.appendAttribute(buf, name, sValue);
        }
    }

    public static String buildQueryString(Map<?, ?> params, boolean ignoreEmpty) {
        StringBuilder buf = new StringBuilder(params.size() * 32);
        for (Map.Entry<?, ?> param : params.entrySet()) {
            String value;
            String name = String.valueOf(param.getKey());
            String string = value = param.getValue() == null ? "" : String.valueOf(param.getValue());
            if (StringUtil.isEmpty(value) && ignoreEmpty) continue;
            buf.append(buf.length() > 0 ? "&" : "").append(name).append("=").append(HtmlUtil.urlEncode(value));
        }
        return buf.toString();
    }

    public static Map<String, String> parseQueryString(String query, boolean ignoreEmpty) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query == null || query.length() == 0) {
            return result;
        }
        if (query.charAt(0) == '?') {
            query = query.substring(1);
        }
        if (query.length() == 0) {
            return result;
        }
        for (String param : query.split("&")) {
            int delimIdx = param.indexOf(61);
            if (delimIdx < 0) {
                throw new RuntimeException("unparsable parameter: " + param);
            }
            String name = param.substring(0, delimIdx);
            String value = param.substring(delimIdx + 1);
            if (value.length() <= 0 && ignoreEmpty) continue;
            result.put(name, HtmlUtil.urlDecode(value));
        }
        return result;
    }

    public static String htmlToText(String input) {
        if (input == null) {
            input = "";
        }
        input = input.replaceAll("[\r\n]+", " ");
        StringBuilder buf = new StringBuilder(input.trim());
        int openIdx = 0;
        while ((openIdx = buf.indexOf("<", openIdx)) >= 0) {
            int closeIdx = buf.indexOf(">", openIdx);
            if (closeIdx < 0) {
                buf.delete(openIdx, buf.length());
                break;
            }
            String tag = buf.substring(openIdx + 1, closeIdx).trim().toUpperCase();
            buf.delete(openIdx, closeIdx + 1);
            tag = tag.replaceAll("\\s+.*", "");
            if (tag.equals("P") || tag.startsWith("BR")) {
                buf.insert(openIdx, "\n");
                continue;
            }
            if (!tag.equals("LI")) continue;
            buf.insert(openIdx, "\n* ");
        }
        return buf.toString();
    }

    static {
        entityLookup.put("AElig", Character.valueOf('\u00c6'));
        entityLookup.put("Aacute", Character.valueOf('\u00c1'));
        entityLookup.put("Acirc", Character.valueOf('\u00c2'));
        entityLookup.put("Agrave", Character.valueOf('\u00c0'));
        entityLookup.put("Aring", Character.valueOf('\u00c5'));
        entityLookup.put("Atilde", Character.valueOf('\u00c3'));
        entityLookup.put("Auml", Character.valueOf('\u00c4'));
        entityLookup.put("Ccedil", Character.valueOf('\u00c7'));
        entityLookup.put("ETH", Character.valueOf('\u00d0'));
        entityLookup.put("Eacute", Character.valueOf('\u00c9'));
        entityLookup.put("Ecirc", Character.valueOf('\u00ca'));
        entityLookup.put("Egrave", Character.valueOf('\u00c8'));
        entityLookup.put("Euml", Character.valueOf('\u00cb'));
        entityLookup.put("Iacute", Character.valueOf('\u00cd'));
        entityLookup.put("Icirc", Character.valueOf('\u00ce'));
        entityLookup.put("Igrave", Character.valueOf('\u00cc'));
        entityLookup.put("Iuml", Character.valueOf('\u00cf'));
        entityLookup.put("Ntilde", Character.valueOf('\u00d1'));
        entityLookup.put("Oacute", Character.valueOf('\u00d3'));
        entityLookup.put("Ocirc", Character.valueOf('\u00d4'));
        entityLookup.put("Ograve", Character.valueOf('\u00d2'));
        entityLookup.put("Oslash", Character.valueOf('\u00d8'));
        entityLookup.put("Otilde", Character.valueOf('\u00d5'));
        entityLookup.put("Ouml", Character.valueOf('\u00d6'));
        entityLookup.put("THORN", Character.valueOf('\u00de'));
        entityLookup.put("Uacute", Character.valueOf('\u00da'));
        entityLookup.put("Ucirc", Character.valueOf('\u00db'));
        entityLookup.put("Ugrave", Character.valueOf('\u00d9'));
        entityLookup.put("Uuml", Character.valueOf('\u00dc'));
        entityLookup.put("Yacute", Character.valueOf('\u00dd'));
        entityLookup.put("aacute", Character.valueOf('\u00e1'));
        entityLookup.put("acirc", Character.valueOf('\u00e2'));
        entityLookup.put("acute", Character.valueOf('\u00b4'));
        entityLookup.put("aelig", Character.valueOf('\u00e6'));
        entityLookup.put("agrave", Character.valueOf('\u00e0'));
        entityLookup.put("amp", Character.valueOf('&'));
        entityLookup.put("apos", Character.valueOf('\''));
        entityLookup.put("aring", Character.valueOf('\u00e5'));
        entityLookup.put("atilde", Character.valueOf('\u00e3'));
        entityLookup.put("auml", Character.valueOf('\u00e4'));
        entityLookup.put("brvbar", Character.valueOf('\u00a6'));
        entityLookup.put("ccedil", Character.valueOf('\u00e7'));
        entityLookup.put("cedil", Character.valueOf('\u00b8'));
        entityLookup.put("cent", Character.valueOf('\u00a2'));
        entityLookup.put("copy", Character.valueOf('\u00a9'));
        entityLookup.put("curren", Character.valueOf('\u00a4'));
        entityLookup.put("deg", Character.valueOf('\u00b0'));
        entityLookup.put("divide", Character.valueOf('\u00f7'));
        entityLookup.put("eacute", Character.valueOf('\u00e9'));
        entityLookup.put("ecirc", Character.valueOf('\u00ea'));
        entityLookup.put("egrave", Character.valueOf('\u00e8'));
        entityLookup.put("eth", Character.valueOf('\u00f0'));
        entityLookup.put("euml", Character.valueOf('\u00eb'));
        entityLookup.put("frac12", Character.valueOf('\u00bd'));
        entityLookup.put("frac14", Character.valueOf('\u00bc'));
        entityLookup.put("frac34", Character.valueOf('\u00be'));
        entityLookup.put("gt", Character.valueOf('>'));
        entityLookup.put("iacute", Character.valueOf('\u00ed'));
        entityLookup.put("icirc", Character.valueOf('\u00ee'));
        entityLookup.put("iexcl", Character.valueOf('\u00a1'));
        entityLookup.put("igrave", Character.valueOf('\u00ec'));
        entityLookup.put("iquest", Character.valueOf('\u00bf'));
        entityLookup.put("iuml", Character.valueOf('\u00ef'));
        entityLookup.put("laquo", Character.valueOf('\u00ab'));
        entityLookup.put("lt", Character.valueOf('<'));
        entityLookup.put("macr", Character.valueOf('\u00af'));
        entityLookup.put("micro", Character.valueOf('\u00b5'));
        entityLookup.put("middot", Character.valueOf('\u00b7'));
        entityLookup.put("nbsp", Character.valueOf('\u00a0'));
        entityLookup.put("not", Character.valueOf('\u00ac'));
        entityLookup.put("ntilde", Character.valueOf('\u00f1'));
        entityLookup.put("oacute", Character.valueOf('\u00f3'));
        entityLookup.put("ocirc", Character.valueOf('\u00f4'));
        entityLookup.put("ograve", Character.valueOf('\u00f2'));
        entityLookup.put("ordf", Character.valueOf('\u00aa'));
        entityLookup.put("ordm", Character.valueOf('\u00ba'));
        entityLookup.put("oslash", Character.valueOf('\u00f8'));
        entityLookup.put("otilde", Character.valueOf('\u00f5'));
        entityLookup.put("ouml", Character.valueOf('\u00f6'));
        entityLookup.put("para", Character.valueOf('\u00b6'));
        entityLookup.put("plusmn", Character.valueOf('\u00b1'));
        entityLookup.put("pound", Character.valueOf('\u00a3'));
        entityLookup.put("quot", Character.valueOf('\"'));
        entityLookup.put("raquo", Character.valueOf('\u00bb'));
        entityLookup.put("reg", Character.valueOf('\u00ae'));
        entityLookup.put("sect", Character.valueOf('\u00a7'));
        entityLookup.put("shy", Character.valueOf('\u00ad'));
        entityLookup.put("sup1", Character.valueOf('\u00b9'));
        entityLookup.put("sup2", Character.valueOf('\u00b2'));
        entityLookup.put("sup3", Character.valueOf('\u00b3'));
        entityLookup.put("szlig", Character.valueOf('\u00df'));
        entityLookup.put("thorn", Character.valueOf('\u00fe'));
        entityLookup.put("times", Character.valueOf('\u00d7'));
        entityLookup.put("uacute", Character.valueOf('\u00fa'));
        entityLookup.put("ucirc", Character.valueOf('\u00fb'));
        entityLookup.put("ugrave", Character.valueOf('\u00f9'));
        entityLookup.put("uml", Character.valueOf('\u00a8'));
        entityLookup.put("uuml", Character.valueOf('\u00fc'));
        entityLookup.put("yacute", Character.valueOf('\u00fd'));
        entityLookup.put("yen", Character.valueOf('\u00a5'));
        entityLookup.put("yuml", Character.valueOf('\u00ff'));
    }
}

