/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceSort {
    public static void sort(int[] array, IntComparator comparator) {
        InplaceSort.sort(new IntArrayAccessor(array, 0, array.length, comparator));
    }

    public static void sort(int[] array, int fromIndex, int toIndex, IntComparator comparator) {
        InplaceSort.sort(new IntArrayAccessor(array, fromIndex, toIndex, comparator));
    }

    public static <T extends Comparable<T>> void sort(T[] array) {
        InplaceSort.sort(array, new ComparableComparator());
    }

    public static <T extends Comparable<T>> void sort(T[] array, int fromIndex, int toIndex) {
        InplaceSort.sort(array, fromIndex, toIndex, new ComparableComparator());
    }

    public static <T> void sort(T[] array, Comparator<T> comparator) {
        InplaceSort.sort(new ObjectArrayAccessor<T>(array, 0, array.length, comparator));
    }

    public static <T> void sort(T[] array, int fromIndex, int toIndex, Comparator<T> comparator) {
        InplaceSort.sort(new ObjectArrayAccessor<T>(array, fromIndex, toIndex, comparator));
    }

    public static <T extends Comparable<T>> void sort(List<T> list) {
        InplaceSort.sort(list, new ComparableComparator());
    }

    public static <T extends Comparable<T>> void sort(List<T> list, int fromIndex, int toIndex) {
        InplaceSort.sort(list, fromIndex, toIndex, new ComparableComparator());
    }

    public static <T> void sort(List<T> list, Comparator<T> comparator) {
        InplaceSort.sort(new ListAccessor<T>(list, 0, list.size(), comparator));
    }

    public static <T> void sort(List<T> list, int fromIndex, int toIndex, Comparator<T> comparator) {
        InplaceSort.sort(new ListAccessor<T>(list, fromIndex, toIndex, comparator));
    }

    public static void sort(Accessor acc) {
        int ii;
        int start = acc.start();
        int end = acc.end();
        for (ii = start + 1; ii < end; ++ii) {
            InplaceSort.siftUp(acc, start, ii);
        }
        ii = end - 1;
        while (ii >= start) {
            acc.swap(start, ii);
            InplaceSort.siftDown(acc, start, --ii);
        }
    }

    private static void siftUp(Accessor acc, int start, int end) {
        int parent;
        while (end > start && acc.compare(parent = start + (end - start - 1) / 2, end) <= 0) {
            acc.swap(parent, end);
            end = parent;
        }
    }

    private static void siftDown(Accessor acc, int start, int end) {
        int parent = start;
        while (parent < end) {
            int child;
            int child1 = start + (parent - start) * 2 + 1;
            int child2 = child1 + 1;
            int n = child2 > end ? child1 : (child = acc.compare(child1, child2) < 0 ? child2 : child1);
            if (child > end) break;
            if (acc.compare(parent, child) < 0) {
                acc.swap(parent, child);
            }
            parent = child;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableComparator<T extends Comparable<T>>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ComparableComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListAccessor<T>
    implements Accessor {
        private List<T> _list;
        private int _start;
        private int _end;
        private Comparator<T> _comparator;

        public ListAccessor(List<T> list, int start, int end, Comparator<T> comparator) {
            this._list = list;
            this._start = start;
            this._end = end;
            this._comparator = comparator;
        }

        @Override
        public int start() {
            return this._start;
        }

        @Override
        public int end() {
            return this._end;
        }

        @Override
        public int compare(int index1, int index2) {
            return this._comparator.compare(this._list.get(index1), this._list.get(index2));
        }

        @Override
        public void swap(int index1, int index2) {
            T tmp = this._list.get(index1);
            this._list.set(index1, this._list.get(index2));
            this._list.set(index2, tmp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectArrayAccessor<T>
    implements Accessor {
        private T[] _array;
        private int _start;
        private int _end;
        private Comparator<T> _comparator;

        public ObjectArrayAccessor(T[] array, int start, int end, Comparator<T> comparator) {
            this._array = array;
            this._start = start;
            this._end = end;
            this._comparator = comparator;
        }

        @Override
        public int start() {
            return this._start;
        }

        @Override
        public int end() {
            return this._end;
        }

        @Override
        public int compare(int index1, int index2) {
            return this._comparator.compare(this._array[index1], this._array[index2]);
        }

        @Override
        public void swap(int index1, int index2) {
            T tmp = this._array[index1];
            this._array[index1] = this._array[index2];
            this._array[index2] = tmp;
        }
    }

    private static class IntArrayAccessor
    implements Accessor {
        private int[] _array;
        private int _start;
        private int _end;
        private IntComparator _comparator;

        public IntArrayAccessor(int[] array, int start, int end, IntComparator comparator) {
            this._array = array;
            this._start = start;
            this._end = end;
            this._comparator = comparator;
        }

        public int start() {
            return this._start;
        }

        public int end() {
            return this._end;
        }

        public int compare(int index1, int index2) {
            return this._comparator.compare(this._array[index1], this._array[index2]);
        }

        public void swap(int index1, int index2) {
            int tmp = this._array[index1];
            this._array[index1] = this._array[index2];
            this._array[index2] = tmp;
        }
    }

    public static interface Accessor {
        public int start();

        public int end();

        public int compare(int var1, int var2);

        public void swap(int var1, int var2);
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

