/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMultimap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Behavior _behavior;
    private int _size = 0;
    private int _modCount = 0;
    private HashEntry<K, V>[] _table;
    private int _mask;
    private int _resizeThreshold;
    private int _filledSlots;
    private HashEntry<K, V> _prev;

    public HashMultimap(Behavior behavior, int initialCapacity, double loadFactor) {
        this._behavior = behavior;
        int realCapacity = 8;
        while (initialCapacity > 8) {
            realCapacity <<= 1;
            initialCapacity >>= 1;
        }
        this._mask = realCapacity - 1;
        this._table = new HashEntry[realCapacity];
        this._resizeThreshold = (int)((double)this._table.length * loadFactor);
    }

    public HashMultimap(Behavior behavior) {
        this(behavior, 8, 0.75);
    }

    public HashMultimap() {
        this(Behavior.SET, 8, 0.75);
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        ++this._modCount;
        this._size = 0;
        for (int ii = 0; ii < this._table.length; ++ii) {
            this._table[ii] = null;
        }
    }

    public void put(K key, V value) {
        int index;
        HashEntry<K, V> current;
        if (this._filledSlots >= this._resizeThreshold) {
            this.resize();
        }
        if ((current = this.findEntry(this._table[index = this.index(key)], key, value)) != null && this._behavior == Behavior.SET) {
            return;
        }
        if (current == null) {
            current = this._table[index];
        }
        current = this.skipToEnd(current);
        ++this._size;
        ++this._modCount;
        if (current == null) {
            this._table[index] = new HashEntry<K, V>(key, value, null);
            ++this._filledSlots;
        } else {
            current.next = new HashEntry<K, V>(key, value, null);
        }
    }

    public V get(K key) {
        HashEntry<K, V> current = this.findFirstEntry(key);
        return current == null ? null : (V)current.value;
    }

    public Collection<V> getAll(K key) {
        AbstractCollection result = this._behavior == Behavior.LIST ? new ArrayList() : new HashSet();
        Iterator<V> itx = this.getIterator(key);
        while (itx.hasNext()) {
            result.add(itx.next());
        }
        return result;
    }

    public Iterator<V> getIterator(K key) {
        return new KeyIterator(key);
    }

    public Iterable<V> getIterable(K key) {
        return new KeyIterable(key);
    }

    public V remove(K key) {
        KeyIterator itx = new KeyIterator(key);
        if (itx.hasNext()) {
            Object result = itx.next();
            itx.remove();
            return (V)result;
        }
        return null;
    }

    public Collection<V> removeAll(K key) {
        ArrayList<V> result = new ArrayList<V>();
        Iterator<V> itx = this.getIterator(key);
        while (itx.hasNext()) {
            result.add(itx.next());
            itx.remove();
        }
        return result;
    }

    public boolean remove(K key, V value) {
        KeyValueIterator itx = new KeyValueIterator(key, value);
        if (itx.hasNext()) {
            itx.next();
            itx.remove();
            return true;
        }
        return false;
    }

    public Collection<V> removeAll(K key, V value) {
        ArrayList<V> result = new ArrayList<V>();
        Iterator<V> itx = this.getIterator(key);
        while (itx.hasNext()) {
            result.add(itx.next());
            itx.remove();
        }
        return result;
    }

    public boolean containsKey(K key) {
        return this.findFirstEntry(key) != null;
    }

    public boolean containsMapping(K key, V value) {
        return this.findFirstEntry(key, value) != null;
    }

    public Set<K> keySet() {
        HashSet ret = new HashSet();
        InternalEntryIterator itx = new InternalEntryIterator();
        while (itx.hasNext()) {
            ret.add(((HashEntry)itx.next()).key);
        }
        return ret;
    }

    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> result = new ArrayList<Map.Entry<K, V>>(this.size());
        Iterator<Map.Entry<K, V>> entryItx = this.entryIterator();
        while (entryItx.hasNext()) {
            result.add(entryItx.next());
        }
        return result;
    }

    public Iterator<Map.Entry<K, V>> entryIterator() {
        return new PublicEntryIterator();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashMultimap) {
            HashMultimap that = (HashMultimap)obj;
            if (this.size() != that.size()) {
                return false;
            }
            for (Map.Entry<K, V> entry : this.entries()) {
                if (that.containsMapping(entry.getKey(), entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int hashCode = 0;
        InternalEntryIterator itx = new InternalEntryIterator();
        while (itx.hasNext()) {
            hashCode = hashCode * 37 + ((HashEntry)itx.next()).getKey().hashCode();
        }
        return hashCode;
    }

    private int index(K key) {
        return key.hashCode() & this._mask;
    }

    private HashEntry<K, V> findFirstEntry(K key) {
        return this.findEntry(this._table[this.index(key)], key);
    }

    private HashEntry<K, V> findFirstEntry(K key, V value) {
        return this.findEntry(this._table[this.index(key)], key, value);
    }

    private HashEntry<K, V> findEntry(HashEntry<K, V> current, K key) {
        this._prev = null;
        while (current != null) {
            if (current.isEqualTo(key)) {
                return current;
            }
            this._prev = current;
            current = current.next;
        }
        return null;
    }

    private HashEntry<K, V> findEntry(HashEntry<K, V> current, K key, V value) {
        this._prev = null;
        while (current != null) {
            if (current.isEqualTo(key, value)) {
                return current;
            }
            this._prev = current;
            current = current.next;
        }
        return null;
    }

    private HashEntry<K, V> skipToEnd(HashEntry<K, V> current) {
        while (current != null && current.next != null) {
            current = current.next;
        }
        return current;
    }

    private void resize() {
        int ii;
        if ((this._mask & 0x40000000) != 0) {
            this._resizeThreshold = Integer.MAX_VALUE;
            return;
        }
        HashEntry<K, V>[] oldTable = this._table;
        ++this._modCount;
        this._table = new HashEntry[oldTable.length * 2];
        this._mask = this._mask << 1 | 1;
        this._resizeThreshold *= 2;
        HashEntry[] tmpTable = new HashEntry[oldTable.length * 2];
        for (ii = 0; ii < oldTable.length; ++ii) {
            HashEntry<Object, Object> current = oldTable[ii];
            while (current != null) {
                int newSlot = current.key.hashCode() & this._mask;
                if (this._table[newSlot] == null) {
                    this._table[newSlot] = current;
                }
                if (tmpTable[newSlot] != null) {
                    tmpTable[newSlot].next = current;
                }
                tmpTable[newSlot] = current;
                current = current.next;
            }
        }
        this._filledSlots = 0;
        for (ii = 0; ii < tmpTable.length; ++ii) {
            if (tmpTable[ii] == null) continue;
            tmpTable[ii].next = null;
            ++this._filledSlots;
        }
    }

    protected int getTableSize() {
        return this._table.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PublicEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private InternalEntryIterator _realItx;

        private PublicEntryIterator() {
            this._realItx = new InternalEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this._realItx.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return this._realItx.next();
        }

        @Override
        public void remove() {
            this._realItx.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalEntryIterator
    implements Iterator<HashEntry<K, V>> {
        protected int _myModCount;
        protected int _tableIndex;
        protected HashEntry<K, V> _current;

        public InternalEntryIterator() {
            this._myModCount = HashMultimap.this._modCount;
            this._tableIndex = 0;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            if (this._myModCount != HashMultimap.this._modCount) {
                throw new ConcurrentModificationException();
            }
            return this._current != null;
        }

        @Override
        public HashEntry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("end of entry iterator");
            }
            HashEntry ret = this._current;
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            if (this._current != null) {
                this._current = this._current.next;
            }
            while (this._current == null && this._tableIndex < HashMultimap.this._table.length) {
                this._current = HashMultimap.this._table[this._tableIndex++];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValueIterator
    extends KeyIterator
    implements Iterator<V> {
        private V _myValue;

        public KeyValueIterator(K key, V value) {
            super(key);
            this._myValue = value;
            this._current = HashMultimap.this.findFirstEntry(key, value);
            this._pred = HashMultimap.this._prev;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more values for: " + this._myKey);
            }
            if (this._current != null) {
                this._last = this._current;
                this._pred = HashMultimap.this._prev;
                this._current = HashMultimap.this.findEntry(this._current.next, this._myKey, this._myValue);
            }
            return this._last.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<V> {
        protected int _myModCount;
        protected K _myKey;
        protected HashEntry<K, V> _pred;
        protected HashEntry<K, V> _current;
        protected HashEntry<K, V> _last;

        public KeyIterator(K key) {
            this._myModCount = HashMultimap.this._modCount;
            this._myKey = key;
            this._current = HashMultimap.this.findFirstEntry(key);
            this._pred = HashMultimap.this._prev;
        }

        @Override
        public boolean hasNext() {
            if (this._myModCount != HashMultimap.this._modCount) {
                throw new ConcurrentModificationException();
            }
            return this._current != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more values for: " + this._myKey);
            }
            if (this._current != null) {
                this._last = this._current;
                this._pred = HashMultimap.this._prev;
                this._current = HashMultimap.this.findEntry(this._current.next, this._myKey);
            }
            return this._last.value;
        }

        @Override
        public void remove() {
            if (this._last == null) {
                throw new IllegalStateException("must call next()");
            }
            if (this._pred == null) {
                ((HashMultimap)HashMultimap.this)._table[((HashMultimap)HashMultimap.this).index(this._myKey)] = this._last.next;
            } else {
                this._pred.next = this._last.next;
            }
            HashMultimap.this._size--;
            this._myModCount = ++HashMultimap.this._modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterable
    implements Iterable<V> {
        private K _myKey;

        public KeyIterable(K key) {
            this._myKey = key;
        }

        @Override
        public Iterator<V> iterator() {
            return new KeyIterator(this._myKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashEntry<KK, VV>
    implements Map.Entry<KK, VV>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public KK key;
        public VV value;
        public HashEntry<KK, VV> next;

        public HashEntry(KK key, VV value, HashEntry<KK, VV> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public boolean isEqualTo(KK k) {
            return this.key.equals(k);
        }

        public boolean isEqualTo(KK k, VV v) {
            if (!this.isEqualTo(k)) {
                return false;
            }
            if (this.value == null) {
                return v == null;
            }
            return this.value.equals(v);
        }

        public String toString() {
            return super.toString() + "[" + this.key + "," + this.value + "," + (this.next == null ? "null" : Integer.toHexString(System.identityHashCode(this.next))) + "]";
        }

        @Override
        public KK getKey() {
            return this.key;
        }

        @Override
        public VV getValue() {
            return this.value;
        }

        @Override
        public VV setValue(VV value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Behavior {
        LIST,
        SET;

    }
}

