/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static <T> Set<T> asSet(T ... elems) {
        HashSet<T> result = new HashSet<T>();
        for (T elem : elems) {
            result.add(elem);
        }
        return result;
    }

    public static <T> void addAll(Collection<T> coll, T ... elems) {
        for (T elem : elems) {
            coll.add(elem);
        }
    }

    public static <T> void addAll(Collection<T> coll, Iterator<T> src) {
        while (src.hasNext()) {
            coll.add(src.next());
        }
    }

    public static <T> void addAll(Collection<T> coll, Iterable<T> src) {
        CollectionUtil.addAll(coll, src.iterator());
    }

    public static <T> Collection<T> addIf(Collection<T> coll, T value, boolean expr) {
        if (expr) {
            coll.add(value);
        }
        return coll;
    }

    public static <T> Collection<T> addIfNotNull(Collection<T> coll, T value) {
        return CollectionUtil.addIf(coll, value, value != null);
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
            return value;
        }
        return map.get(key);
    }

    public static <K, V> void putIfAbsent(Map<K, V> base, Map<K, V> add) {
        for (Map.Entry<K, V> entry : add.entrySet()) {
            CollectionUtil.putIfAbsent(base, entry.getKey(), entry.getValue());
        }
    }

    public static <T> T first(List<T> list) {
        return CollectionUtil.isNotEmpty(list) ? (T)list.get(0) : null;
    }

    public static <T> T last(List<T> list) {
        return CollectionUtil.isNotEmpty(list) ? (T)list.get(list.size() - 1) : null;
    }

    public static <T> List<T> cast(List<?> list, Class<T> klass) {
        for (Object obj : list) {
            klass.cast(obj);
        }
        return list;
    }

    public static <T> Set<T> cast(Set<?> set, Class<T> klass) {
        for (Object obj : set) {
            klass.cast(obj);
        }
        return set;
    }

    public static <T> List<T> resize(List<T> list, int newSize, T obj) {
        block7: {
            block6: {
                if (list instanceof ArrayList) {
                    ((ArrayList)list).ensureCapacity(newSize);
                }
                if (list.size() >= newSize) break block6;
                for (int ii = list.size(); ii < newSize; ++ii) {
                    list.add(obj);
                }
                break block7;
            }
            if (list.size() <= newSize) break block7;
            if (list instanceof RandomAccess) {
                for (int ii = list.size() - 1; ii >= newSize; --ii) {
                    list.remove(ii);
                }
            } else {
                ListIterator<T> itx = list.listIterator(newSize);
                while (itx.hasNext()) {
                    itx.next();
                    itx.remove();
                }
            }
        }
        return list;
    }

    public static <T> List<T> resize(List<T> list, int newSize) {
        return CollectionUtil.resize(list, newSize, null);
    }

    public static <T> String join(Iterable<T> coll, String delim) {
        if (coll == null) {
            return "";
        }
        boolean isFirst = true;
        StringBuilder buf = new StringBuilder(1024);
        for (T item : coll) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(delim);
            }
            if (item == null) continue;
            buf.append(String.valueOf(item));
        }
        return buf.toString();
    }

    public static <T> List<T> combine(List<T> dest, Collection<T> ... src) {
        for (Collection<T> cc : src) {
            dest.addAll(cc);
        }
        return dest;
    }

    public static <T> Set<T> combine(Set<T> dest, Collection<T> ... src) {
        for (Collection<T> cc : src) {
            dest.addAll(cc);
        }
        return dest;
    }

    public static <K, V> Map<K, V> combine(Map<K, V> dest, Map<K, V> ... src) {
        for (Map<K, V> cc : src) {
            dest.putAll(cc);
        }
        return dest;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null ? true : c.size() == 0;
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return c != null && c.size() > 0;
    }

    public static int compare(Collection<? extends Comparable> c1, Collection<? extends Comparable> c2) {
        Iterator<? extends Comparable> itx1 = c1.iterator();
        Iterator<? extends Comparable> itx2 = c2.iterator();
        while (itx1.hasNext()) {
            Comparable v2;
            if (!itx2.hasNext()) {
                return 1;
            }
            Comparable v1 = itx1.next();
            int cmp = v1.compareTo(v2 = itx2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (itx2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T> Iterable<T> defaultIfNull(Iterable<T> reg, Iterable<T> def) {
        return reg == null ? def : reg;
    }

    public static <T> Collection<T> defaultIfEmpty(Collection<T> reg, Collection<T> def) {
        return reg == null || reg.size() == 0 ? def : reg;
    }

    public static <V, R> List<R> map(Collection<V> coll, IndexValueMapFunctor<V, R> functor) {
        ArrayList<R> result = new ArrayList<R>(coll.size());
        int index = 0;
        for (V value : coll) {
            try {
                result.add(functor.invoke(index, value));
                ++index;
            }
            catch (Throwable ex) {
                throw new MapException(ex, index, value, result);
            }
        }
        return result;
    }

    public static <V, R> List<R> map(ExecutorService threadpool, Collection<V> values, final IndexValueMapFunctor<V, R> functor) throws InterruptedException {
        int count = values.size();
        ArrayList<V> values2 = new ArrayList<V>(values);
        ArrayList futures = new ArrayList(count);
        ArrayList results = new ArrayList();
        CollectionUtil.resize(results, count);
        for (int ii = 0; ii < count; ++ii) {
            final int index = ii;
            final V value = values2.get(ii);
            futures.add(threadpool.submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    return functor.invoke(index, value);
                }
            }));
        }
        int failureIndex = 0;
        Throwable failureException = null;
        for (int ii = 0; ii < count; ++ii) {
            Future future = (Future)futures.get(ii);
            try {
                results.set(ii, future.get());
                continue;
            }
            catch (CancellationException ex) {
                failureIndex = ii;
                failureException = ex;
                continue;
            }
            catch (ExecutionException ex) {
                failureIndex = ii;
                failureException = ex.getCause();
            }
        }
        if (failureException != null) {
            throw new MapException(failureException, failureIndex, values2.get(failureIndex), results);
        }
        return results;
    }

    public static <V, R> R reduce(Collection<V> coll, IndexValueReduceFunctor<V, R> functor) {
        Object pendingResult = null;
        int index = 0;
        for (V value : coll) {
            try {
                pendingResult = functor.invoke(index, value, pendingResult);
                ++index;
            }
            catch (Throwable ex) {
                throw new ReduceException(ex, index, value, pendingResult);
            }
        }
        return pendingResult;
    }

    public static <V> List<V> filter(Collection<V> coll, Predicate<V> predicate) {
        ArrayList<V> result = new ArrayList<V>(coll.size());
        int index = 0;
        for (V value : coll) {
            try {
                if (predicate.invoke(index, value)) {
                    result.add(value);
                }
                ++index;
            }
            catch (Throwable ex) {
                throw new FilterException(ex, index, value, result);
            }
        }
        return result;
    }

    public static <T> List<T> filter(List<T> list, String regex, final boolean include) {
        final Pattern pattern = Pattern.compile(regex);
        return CollectionUtil.filter(list, new Predicate<T>(){

            @Override
            public boolean invoke(int index, T value) throws Exception {
                String str = value == null ? "" : value.toString();
                return pattern.matcher(str).matches() == include;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private int _index;
        private Object _value;
        private List<?> _partialResults;

        public FilterException(Throwable cause, int index, Object value, List<?> partialResults) {
            super(cause);
            this._index = index;
            this._value = value;
            this._partialResults = partialResults;
        }

        public int getIndex() {
            return this._index;
        }

        public Object getValue() {
            return this._value;
        }

        public List<?> getPartialResults() {
            return this._partialResults;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<V> {
        public boolean invoke(int var1, V var2) throws Exception;
    }

    public static class ReduceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private int _index;
        private Object _value;
        private Object _partialResults;

        public ReduceException(Throwable cause, int index, Object value, Object partialResults) {
            super(cause);
            this._index = index;
            this._value = value;
            this._partialResults = partialResults;
        }

        public int getIndex() {
            return this._index;
        }

        public Object getValue() {
            return this._value;
        }

        public Object getPartialResults() {
            return this._partialResults;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IndexValueReduceFunctor<V, R> {
        public R invoke(int var1, V var2, R var3) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private int _index;
        private Object _value;
        private List<?> _partialResults;

        public MapException(Throwable cause, int index, Object value, List<?> partialResults) {
            super(cause);
            this._index = index;
            this._value = value;
            this._partialResults = partialResults;
        }

        public int getIndex() {
            return this._index;
        }

        public Object getValue() {
            return this._value;
        }

        public List<?> getPartialResults() {
            return this._partialResults;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IndexValueMapFunctor<V, R> {
        public R invoke(int var1, V var2) throws Exception;
    }
}

