/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.codec;

import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.Codec;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.CodecException;
import eu.ha3.matmos.lib.net.sf.kdgcommons.codec.InvalidSourceByteException;
import eu.ha3.matmos.lib.net.sf.kdgcommons.lang.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HexCodec
extends Codec {
    private int _lineLength;
    private byte[] _separator;
    private static char[] nibbleToChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public HexCodec() {
        this._lineLength = Integer.MAX_VALUE;
    }

    public HexCodec(int lineLength, String separator) {
        this._lineLength = lineLength;
        this._separator = StringUtil.toUTF8(separator);
    }

    public void encode(InputStream in, OutputStream out) {
        new Encoder(in, out).encode();
    }

    public void decode(InputStream in, OutputStream out) {
        new Decoder(in, out).decode();
    }

    public String toString(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        byte[] encoded = this.encode(data);
        return StringUtil.fromUTF8(encoded);
    }

    public byte[] toBytes(String str) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY_ARRAY;
        }
        byte[] bytes = StringUtil.toUTF8(str);
        return this.decode(bytes);
    }

    private static int charToNibble(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        throw new InvalidSourceByteException(c);
    }

    private class Decoder {
        private InputStream _in;
        private OutputStream _out;

        public Decoder(InputStream in, OutputStream out) {
            this._in = Codec.wrapIfNeeded(in, HexCodec.this._separator);
            this._out = out;
        }

        public void decode() {
            try {
                while (true) {
                    Codec.skipIfSeparator(this._in, HexCodec.this._separator);
                    int v1 = Codec.nextNonWhitespace(this._in);
                    int v2 = Codec.nextNonWhitespace(this._in);
                    if (v1 < 0 || v2 < 0) {
                        return;
                    }
                    int n1 = HexCodec.charToNibble(v1);
                    int n2 = HexCodec.charToNibble(v2);
                    this._out.write(n1 << 4 | n2);
                }
            }
            catch (CodecException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CodecException("unable to decode", ex);
            }
        }
    }

    private class Encoder {
        private InputStream _in;
        private OutputStream _out;
        private int _breakCount;

        public Encoder(InputStream in, OutputStream out) {
            this._in = in;
            this._out = out;
        }

        public void encode() {
            try {
                int val = 0;
                while ((val = this._in.read()) >= 0) {
                    this.insertBreakIfNeeded();
                    this._out.write(nibbleToChar[val >> 4]);
                    this._out.write(nibbleToChar[val & 0xF]);
                    this._breakCount += 2;
                }
            }
            catch (CodecException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CodecException("unable to encode", ex);
            }
        }

        private void insertBreakIfNeeded() throws IOException {
            if (HexCodec.this._separator != null && this._breakCount >= HexCodec.this._lineLength) {
                this._out.write(HexCodec.this._separator);
                this._breakCount = 0;
            }
        }
    }
}

