/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.net.sf.kdgcommons.codec;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Codec {
    protected static final byte[] EMPTY_ARRAY = new byte[0];

    public abstract void encode(InputStream var1, OutputStream var2);

    public abstract void decode(InputStream var1, OutputStream var2);

    public byte[] encode(byte[] src) {
        if (src == null || src.length == 0) {
            return EMPTY_ARRAY;
        }
        return this.encode(src, 0, src.length);
    }

    public byte[] encode(byte[] src, int off, int len) {
        ByteArrayInputStream in = new ByteArrayInputStream(src, off, len);
        ByteArrayOutputStream out = new ByteArrayOutputStream(src.length);
        this.encode(in, out);
        return out.toByteArray();
    }

    public byte[] decode(byte[] src) {
        if (src == null || src.length == 0) {
            return EMPTY_ARRAY;
        }
        return this.decode(src, 0, src.length);
    }

    public byte[] decode(byte[] src, int off, int len) {
        ByteArrayInputStream in = new ByteArrayInputStream(src, off, len);
        ByteArrayOutputStream out = new ByteArrayOutputStream(src.length);
        this.decode(in, out);
        return out.toByteArray();
    }

    protected static InputStream wrapIfNeeded(InputStream in, byte[] separator) {
        return separator == null || separator.length == 0 ? in : new BufferedInputStream(in, separator.length + 2);
    }

    protected static void skipIfSeparator(InputStream in, byte[] separator) throws IOException {
        if (separator == null) {
            return;
        }
        in.mark(separator.length + 1);
        for (int ii = 0; ii < separator.length; ++ii) {
            int c = in.read();
            if (c == separator[ii]) continue;
            in.reset();
            return;
        }
    }

    protected static int nextNonWhitespace(InputStream in) throws IOException {
        int c;
        do {
            if ((c = in.read()) >= 0) continue;
            return c;
        } while (Character.isWhitespace(c));
        return c;
    }
}

