/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.lib.eu.ha3.mc.quick.update;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.UpdatableIdentity;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.HaddonVersion;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.implem.UpdatableHaddonIdentity;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.chat.Chatter;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.update.NotifiableHaddon;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.update.UpdateCallback;
import eu.ha3.matmos.lib.eu.ha3.mc.quick.update.Updater;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.ConfigProperty;
import eu.ha3.matmos.lib.eu.ha3.util.property.simple.PropertyException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateNotifier
implements Updater {
    private final NotifiableHaddon notifiableHaddon;
    private Queue<UpdatableIdentity> thingsToUpdateCheck = new LinkedList<UpdatableIdentity>();
    private Set<UpdatableIdentity> thingsUpdateChecked = new HashSet<UpdatableIdentity>();
    private Map<UpdatableIdentity, UpdateCallback> updateCallbacks = new HashMap<UpdatableIdentity, UpdateCallback>();
    boolean hasRun;
    private int displayCount = 3;
    private boolean enabled = true;
    private final Logger LOGGER;

    public UpdateNotifier(NotifiableHaddon mod, String ... queries) {
        this(mod, mod.getIdentity().getHaddonVersion(), queries);
    }

    public UpdateNotifier(NotifiableHaddon mod, HaddonVersion currentVersion, String ... queries) {
        this.notifiableHaddon = mod;
        if (!currentVersion.equals(HaddonVersion.NO_VERSION)) {
            this.addJob((UpdatableIdentity)new UpdatableHaddonIdentity(mod.getIdentity(), currentVersion, "mod", new ArrayList<String>(Arrays.asList(queries))), new HaddonVersion(mod.getIdentity().getHaddonMinecraftVersion()));
        }
        this.LOGGER = LogManager.getLogger((String)("updatenotifier-" + mod.getIdentity().getHaddonName()));
    }

    @Override
    public void attempt() {
        if (this.enabled) {
            Queue<UpdatableIdentity> batch = this.thingsToUpdateCheck;
            this.thingsToUpdateCheck = new LinkedList<UpdatableIdentity>();
            new Thread(() -> this.checkForUpdates(batch)).start();
            this.hasRun = true;
        }
    }

    private boolean canBeUpdateChecked(UpdatableIdentity identity) {
        return identity.getUniqueName() != null && !identity.getUniqueName().equals("") && identity.getHaddonVersion() != null && identity.getUpdateURLs() != null && !identity.getUpdateURLs().isEmpty();
    }

    private void checkForUpdates(Queue<UpdatableIdentity> batch) {
        for (UpdatableIdentity id : batch) {
            this.checkUpdates(id);
        }
    }

    public void addJob(UpdatableIdentity identity) {
        this.addJob(identity, HaddonVersion.NO_VERSION);
    }

    public void addJob(UpdatableIdentity identity, HaddonVersion allowedPlatformVersion) {
        this.addJob(identity, (Map<HaddonVersion, Pair<HaddonVersion, Map<String, String>>> p) -> allowedPlatformVersion);
    }

    public void addJob(UpdatableIdentity identity, UpdateCallback cb) {
        if (this.canBeUpdateChecked(identity) && !this.thingsUpdateChecked.contains(identity)) {
            this.thingsUpdateChecked.add(identity);
            this.updateCallbacks.put(identity, cb);
            this.thingsToUpdateCheck.add(identity);
        }
        if (!this.thingsToUpdateCheck.isEmpty() && this.hasRun) {
            this.attempt();
        }
    }

    private void checkUpdates(UpdatableIdentity id) {
        UpdateCallback cb = this.updateCallbacks.remove(id);
        for (String url : id.getUpdateURLs()) {
            try {
                if (!this.checkUpdates(id, url, cb)) continue;
                return;
            }
            catch (Exception e) {
                this.LOGGER.debug("Exception whilst checking update location: " + url);
            }
        }
    }

    private Pair<HaddonVersion, HaddonVersion> solveVersion(String queryLoc, UpdateCallback cb) throws Exception {
        URL url = new URL(queryLoc);
        InputStream contents = url.openStream();
        HaddonVersion solvedVersion = null;
        String jasonString = IOUtils.toString((InputStream)contents, (String)"UTF-8");
        JsonObject jason = new JsonParser().parse(jasonString).getAsJsonObject();
        HashMap<HaddonVersion, Pair<HaddonVersion, Map<String, String>>> latestPerPlatformVer = new HashMap<HaddonVersion, Pair<HaddonVersion, Map<String, String>>>();
        for (Map.Entry e : jason.entrySet()) {
            if (Arrays.asList("homepage", "promos").contains(e.getKey())) continue;
            if (!((JsonElement)e.getValue()).isJsonObject()) {
                this.LOGGER.debug("Ignoring unknown element in update JSON: " + (String)e.getKey());
                continue;
            }
            String platform = (String)e.getKey();
            JsonObject versions = ((JsonElement)e.getValue()).getAsJsonObject();
            List availableVersions = versions.entrySet().stream().map(name -> new HaddonVersion((String)name.getKey())).collect(Collectors.toList());
            HaddonVersion latest = (HaddonVersion)Collections.max(availableVersions);
            latestPerPlatformVer.put(new HaddonVersion(platform), (Pair<HaddonVersion, Map<String, String>>)Pair.of((Object)latest, null));
        }
        HaddonVersion requiredPlatformVer = cb.decidePlatformVersion(latestPerPlatformVer);
        if (requiredPlatformVer == null || requiredPlatformVer.equals(HaddonVersion.NO_VERSION)) {
            requiredPlatformVer = (HaddonVersion)Collections.max(latestPerPlatformVer.keySet());
        }
        if (!latestPerPlatformVer.containsKey(requiredPlatformVer)) {
            this.LOGGER.debug("Update JSON contains no entries for " + requiredPlatformVer.toString() + ". Malformed JSON file?");
            return null;
        }
        solvedVersion = (HaddonVersion)((Pair)latestPerPlatformVer.get(requiredPlatformVer)).getLeft();
        return Pair.of((Object)solvedVersion, (Object)requiredPlatformVer);
    }

    private boolean checkUpdates(UpdatableIdentity id, String queryLoc, UpdateCallback cb) throws Exception {
        this.LOGGER.debug("Checking " + id.getUniqueName() + " for updates");
        HaddonVersion currentVersion = id.getHaddonVersion();
        Pair<HaddonVersion, HaddonVersion> solved = this.solveVersion(queryLoc, cb);
        if (solved == null) {
            return false;
        }
        HaddonVersion solvedVersion = (HaddonVersion)solved.getLeft();
        HaddonVersion solvedMinecraftVersion = (HaddonVersion)solved.getRight();
        this.LOGGER.debug("Update version found: " + solvedVersion + " (running " + currentVersion + ")");
        Thread.sleep(1000L);
        if (solvedVersion.compareTo(currentVersion) > 0) {
            ConfigProperty config = this.notifiableHaddon.getConfig();
            HaddonVersion lastFound = id.getHaddonVersion();
            int displayRemaining = 0;
            try {
                HaddonVersion newLastFound = new HaddonVersion(config.getString("update." + id.getUniqueName() + ".version"));
                int newDisplayRemaining = config.getInteger("update." + id.getUniqueName() + ".display.remaining");
                lastFound = newLastFound;
                displayRemaining = newDisplayRemaining;
            }
            catch (PropertyException newLastFound) {
                // empty catch block
            }
            boolean needsSave = false;
            if (!solvedVersion.equals(lastFound)) {
                lastFound = solvedVersion;
                displayRemaining = this.displayCount;
                needsSave = true;
                config.setProperty("update." + id.getUniqueName() + ".version", lastFound);
                config.setProperty("update." + id.getUniqueName() + ".display.remaining", (Object)displayRemaining);
            }
            if (displayRemaining > 0) {
                config.setProperty("update." + id.getUniqueName() + ".display.remaining", (Object)(--displayRemaining));
                int vc = solvedVersion.getMajorVersion() - currentVersion.getMajorVersion();
                this.reportUpdate(id, solvedMinecraftVersion, solvedVersion, vc, displayRemaining);
                needsSave = true;
            }
            if (needsSave) {
                this.notifiableHaddon.saveConfig();
            }
            return needsSave;
        }
        return false;
    }

    private synchronized void reportUpdate(UpdatableIdentity id, HaddonVersion solvedMC, HaddonVersion solved, int count, int displayRemaining) {
        Chatter chatter = this.notifiableHaddon.getChatter();
        if (solvedMC.equals(HaddonVersion.NO_VERSION)) {
            chatter.printChat(TextFormatting.GOLD, "An update is available for " + id.getHaddonName() + ": ver ", solved);
        } else if (solvedMC.equals(id.getPlatformVersion())) {
            chatter.printChat(TextFormatting.GOLD, "An update is available for " + id.getHaddonName() + " for your version of " + id.getPlatformName() + ": ver ", solved);
        } else {
            chatter.printChat(TextFormatting.GOLD, "An update is available for " + id.getHaddonName());
            chatter.printChatShort(TextFormatting.GOLD, "for ", TextFormatting.GOLD, TextFormatting.ITALIC, "another", TextFormatting.GOLD, " version of " + id.getPlatformName() + ": ");
            chatter.printChatShort(TextFormatting.GOLD, "ver ", solved, TextFormatting.GOLD, " for ver ", solvedMC, TextFormatting.GOLD, ".");
        }
        if (count > 0) {
            chatter.printChatShort(TextFormatting.GOLD, "You're ", TextFormatting.WHITE, count, TextFormatting.GOLD, " major version" + (count > 1 ? "s" : "") + " late.");
        }
        chatter.printChatShort(TextFormatting.UNDERLINE, new ClickEvent(ClickEvent.Action.OPEN_URL, id.getHaddonAddress()), id.getHaddonAddress());
        if (displayRemaining > 0) {
            chatter.printChatShort(TextFormatting.GRAY, "This message will display ", TextFormatting.WHITE, displayRemaining, TextFormatting.GRAY, " more time" + (displayRemaining > 1 ? "s" : "") + ".");
        } else {
            chatter.printChatShort(TextFormatting.GRAY, "You won't be notified anymore unless a newer version comes out.");
        }
    }

    @Override
    public void fillDefaults(ConfigProperty configuration) {
        configuration.createProperty("update.enabled", true, "Enable update checker");
        configuration.createProperty("update.mod.version", this.notifiableHaddon.getIdentity().getHaddonVersion());
        configuration.createProperty("update.mod.display.remaining", 0);
        configuration.createProperty("update.display.count", 3, "How many times to notify about a given version");
    }

    @Override
    public void loadConfig(ConfigProperty configuration) {
        this.enabled = configuration.getBoolean("update.enabled");
        this.displayCount = configuration.getInteger("update.display.count");
    }
}

