/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.gui;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.lib.eu.ha3.mc.gui.HDisplayStringProvider;
import eu.ha3.matmos.lib.eu.ha3.mc.gui.HGuiSliderControl;
import eu.ha3.matmos.lib.eu.ha3.mc.gui.HSliderListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;
import net.minecraft.world.biome.Biome;

public class GuiBiomeSlider
implements HDisplayStringProvider,
HSliderListener {
    protected final Matmos mod;
    protected final int maxBiomes = this.calculateMaxBiomes();
    protected int definedBiomeID;
    private List<Integer> validBiomes = new ArrayList<Integer>();

    public GuiBiomeSlider(Matmos mod, int define) {
        this.mod = mod;
        this.definedBiomeID = define;
        this.computeBiomes();
    }

    private void computeBiomes() {
        Biome i = null;
        Iterator it = Biome.field_185377_q.iterator();
        while (it.hasNext()) {
            this.validBiomes.add(Biome.field_185377_q.func_148757_b(i));
            i = (Biome)it.next();
        }
    }

    @Override
    public void sliderValueChanged(HGuiSliderControl slider, float value) {
        int biomeID = (int)(Math.floor(value * (float)this.validBiomes.size()) - 1.0);
        this.definedBiomeID = biomeID >= 0 && biomeID < this.validBiomes.size() ? this.validBiomes.get(biomeID) : biomeID;
        slider.updateDisplayString();
    }

    @Override
    public void sliderReleased(HGuiSliderControl hGuiSliderControl) {
        this.mod.getConfig().setProperty("useroptions.biome.override", (Object)this.definedBiomeID);
        this.mod.saveConfig();
    }

    @Override
    public String provideDisplayString() {
        String desc = this.getDescriptorString();
        if (desc == null) {
            return "";
        }
        return I18n.func_135052_a((String)"mat.biome.override", (Object[])new Object[]{desc});
    }

    @Nullable
    protected String getDescriptorString() {
        if (this.definedBiomeID >= 0 && this.definedBiomeID <= this.maxBiomes) {
            Biome biome = Biome.func_185357_a((int)this.definedBiomeID);
            if (biome == null) {
                return I18n.func_135052_a((String)"mat.biome.undef", (Object[])new Object[]{this.definedBiomeID});
            }
            if (StringUtils.func_151246_b((String)biome.func_185359_l())) {
                return I18n.func_135052_a((String)"mat.biome.unamed", (Object[])new Object[]{this.definedBiomeID});
            }
            return I18n.func_135052_a((String)"mat.biome.biome", (Object[])new Object[]{biome.func_185359_l(), this.definedBiomeID});
        }
        if (this.definedBiomeID == -1) {
            return I18n.func_135052_a((String)"mat.biome.disabled", (Object[])new Object[0]);
        }
        return null;
    }

    public float calculateSliderLocation(int biomeID) {
        if (biomeID == -1) {
            return 0.0f;
        }
        if (this.validBiomes.contains(biomeID)) {
            return (this.validBiomes.indexOf(biomeID) + 1) / this.validBiomes.size();
        }
        return 1.0f;
    }

    private int calculateMaxBiomes() {
        int max = 0;
        Biome i = null;
        Iterator it = Biome.field_185377_q.iterator();
        while (it.hasNext()) {
            int id = Biome.field_185377_q.func_148757_b(i);
            if (id > max) {
                max = id;
            }
            i = (Biome)it.next();
        }
        return max;
    }
}

