/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.game.user;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.lib.eu.ha3.mc.convenience.Ha3Scroller;
import eu.ha3.matmos.util.MAtUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;

public class VolumeScroller
extends Ha3Scroller {
    private final String MESSAGE_TITLE = "MAtmos Volume";
    private final String MESSAGE_HINT = "<Look up/down>";
    private final String MESSAGE_MORE = "+";
    private final String MESSAGE_LESS = "-";
    private Matmos mod;
    private float prevPitch;
    private boolean knowsHowToUse;
    private float doneValue;

    public VolumeScroller(Matmos mod) {
        super(Minecraft.func_71410_x());
        this.mod = mod;
        this.knowsHowToUse = false;
    }

    @Override
    protected void doDraw(float fspan) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        String msgper = (int)Math.floor(this.doneValue * 100.0f) + "%";
        ScaledResolution screenRes = new ScaledResolution(mc);
        int scrWidth = screenRes.func_78326_a();
        int scrHeight = screenRes.func_78328_b();
        int uwidth = this.getWidthOf("_");
        int uposx = (scrWidth - uwidth) / 2 + this.getWidthOf("MAtmos Volume") / 2;
        fontRenderer.func_175063_a("MAtmos Volume", (float)(uposx + uwidth * 2), (float)(scrHeight / 2), 0xFFFFFF);
        fontRenderer.func_175063_a(msgper, (float)(uposx + uwidth * 2), (float)(scrHeight / 2 + 10), 0xFF0000 | (int)(200.0f + 55.0f * (this.doneValue < 1.0f ? 1.0f : 2.0f - this.doneValue)) << 8);
        if (!this.knowsHowToUse) {
            float glocount = (float)this.mod.util().getClientTick() + fspan;
            int blink = (int)(200.0 + 55.0 * (Math.sin((double)glocount * Math.PI * 0.07) + 1.0) / 2.0);
            fontRenderer.func_175063_a("<Look up/down>", (float)(uposx + uwidth * 2), (float)(scrHeight / 2 + 20), blink << 16 | blink << 8 | blink);
            if (Math.abs(this.getInitialPitch() - this.getPitch()) > 60.0f) {
                this.knowsHowToUse = true;
            }
        }
        fontRenderer.func_175063_a("+", (float)(uposx + uwidth * 2), (float)(scrHeight / 2 - scrHeight / 6 + 3), 0xFFFF00);
        fontRenderer.func_175063_a("-", (float)(uposx + uwidth * 2), (float)(scrHeight / 2 + scrHeight / 6 + 3), 0xFFFF00);
        int ucount = 8;
        float speedytude = 20.0f;
        for (int i = 0; i < 8; ++i) {
            float perx = ((this.getPitch() + 90.0f) % 20.0f / 20.0f + (float)i) / 8.0f;
            double pirx = Math.cos(Math.PI * (double)perx);
            fontRenderer.func_175063_a("_", (float)uposx, (float)(scrHeight / 2 + (int)Math.floor(pirx * (double)scrHeight / 6.0)), 0xFFFF00);
        }
    }

    private int getWidthOf(String s) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
    }

    public float getValue() {
        return this.doneValue;
    }

    @Override
    protected void doRoutineBefore() {
        int caps = 10;
        if (this.mod.getConfig().getBoolean("sound.autopreview") && (int)Math.floor((this.prevPitch + 90.0f) / 10.0f) != (int)Math.floor((this.getPitch() + 90.0f) / 10.0f)) {
            float hgn = (-this.getPitch() + 90.0f) / 90.0f;
            float res = (float)Math.pow(2.0, -Math.floor(this.getPitch() / 10.0f) / 12.0);
            MAtUtil.playSound("ui.button.click", hgn, res);
        }
        this.doneValue = -this.getPitch() / 90.0f + 1.0f;
        if (Math.abs(this.getPitch()) < 3.0f) {
            this.doneValue = 1.0f;
        }
        if (Math.abs(this.doneValue - 0.2f) < 0.05f) {
            this.doneValue = 0.2f;
        }
        this.prevPitch = this.getPitch();
    }

    @Override
    protected void doRoutineAfter() {
    }

    @Override
    protected void doStart() {
        this.prevPitch = this.getPitch();
    }

    @Override
    protected void doStop() {
    }
}

