/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.dealias;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.dealias.AliasEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ObjectAliasMap {
    protected Map<Integer, Integer> dealiasMap = new HashMap<Integer, Integer>();

    public void addMappings(List<AliasEntry> entries) {
        entries.forEach(e -> {
            String k = e.getKey();
            String v = e.getValue();
            int ki = this.getIDFromName(k);
            if (ki > 0) {
                if (v.startsWith(":")) {
                    String oreName = v.substring(1);
                    NonNullList ores = OreDictionary.getOres((String)oreName);
                    if (!ores.isEmpty()) {
                        for (ItemStack is : ores) {
                            int id = this.getItemID(is.func_77973_b());
                            if (id <= 0) continue;
                            this.dealiasMap.put(id, ki);
                        }
                    } else {
                        e.warn("Ignoring invalid oredict name in alias map: " + v);
                    }
                } else if (v.contains("*")) {
                    try {
                        Pattern pattern = this.makePattern(v);
                        boolean matchedName = false;
                        for (ResourceLocation rl : Item.field_150901_e.func_148742_b()) {
                            String name = rl.toString();
                            if (!pattern.matcher(name).matches() && (!name.startsWith("minecraft:") || !pattern.matcher(name.substring("minecraft:".length())).matches())) continue;
                            matchedName = true;
                            int vi = this.getIDFromName(name);
                            if (vi <= 0) continue;
                            this.dealiasMap.put(vi, ki);
                        }
                        if (!matchedName) {
                            e.warn("No name matched pattern " + v);
                        }
                    }
                    catch (Exception e2) {
                        e.warn("Invalid pattern: " + v + " (" + e2 + ")");
                    }
                } else {
                    int vi = this.getIDFromName(v);
                    if (vi > 0) {
                        this.dealiasMap.put(vi, ki);
                    } else if (!this.isValidName(v)) {
                        e.warn("Ignoring invalid name in alias map: " + v);
                    }
                }
            } else if (!this.isValidName(k)) {
                e.warn("Ignoring invalid name in alias map: " + k);
            }
        });
    }

    public boolean isValidName(String name) {
        ResourceLocation nameLoc = new ResourceLocation(name);
        return Item.field_150901_e.func_148741_d((Object)nameLoc) || Block.field_149771_c.func_148741_d((Object)nameLoc);
    }

    public void dealiasItemGroupToMinID(Collection<String> names) {
        List<Integer> ids = names.stream().filter(s -> !s.startsWith("minecraft:")).mapToInt(s -> this.getIDFromName((String)s)).filter(i -> i != -1).boxed().collect(Collectors.toList());
        int minBlockID = ids.stream().min(Integer::compare).orElse(-1);
        Matmos.ALIASLOGGER.debug(this.getLogPrefix() + "filtered IDs: " + Arrays.toString(ids.toArray()));
        Matmos.ALIASLOGGER.debug(this.getLogPrefix() + "min: " + this.getNameFromID(minBlockID) + " (" + minBlockID + ")");
        if (minBlockID != -1) {
            ids.forEach(i -> {
                if (!this.dealiasMap.containsKey(i)) {
                    this.dealiasMap.put((Integer)i, minBlockID);
                }
            });
        }
    }

    Pattern makePattern(String str) throws Exception {
        str = str.replace(".", "\\.").replace("*", ".*");
        Pattern pattern = null;
        pattern = Pattern.compile(str);
        return pattern;
    }

    protected void compile() {
        this.dealiasMap.entrySet().removeIf(e -> {
            Integer i = (Integer)e.getKey();
            int id = i;
            int hops = 0;
            do {
                id = this.dealiasMap.get(id);
                ++hops;
            } while (this.dealiasMap.containsKey(id) && this.dealiasMap.get(id) != id);
            if (id == i && hops > 1) {
                Matmos.LOGGER.warn("Circular dependency detected when dealiasing " + this.getNameFromID(i) + ". Alias will be ignored.");
                return true;
            }
            e.setValue(id);
            return false;
        });
    }

    public int dealiasID(int alias) {
        return this.dealiasMap.getOrDefault(alias, alias);
    }

    public abstract String getLogPrefix();

    public abstract int getIDFromName(String var1);

    public abstract int getItemID(Item var1);

    public abstract String getNameFromID(int var1);
}

