/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.dealias;

import eu.ha3.matmos.ConfigManager;
import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.dealias.AliasEntry;
import eu.ha3.matmos.dealias.BlockAliasMap;
import eu.ha3.matmos.dealias.ItemAliasMap;
import eu.ha3.matmos.util.MAtUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class IDDealiaser {
    private static final String OLD_ALIAS_MAP_SHA256 = "e2fbd8793250808dc2816ab4aba16a2f150a918cb02670b6dca4ec3be4f63469";
    private BlockAliasMap blockAliasMap = new BlockAliasMap();
    private ItemAliasMap itemAliasMap = new ItemAliasMap();

    public IDDealiaser(File configFolder) {
        File theDir = new File(configFolder, "builtin_aliases");
        Matmos.LOGGER.debug("Regenerating " + theDir.getPath());
        ConfigManager.getDefaultConfigHelper().createDefaultConfigFileIfMissing(theDir, true, false);
        if (ConfigManager.getConfig().getBoolean("dealias.oredict")) {
            for (String oreName : OreDictionary.getOreNames()) {
                ArrayList<String> names = new ArrayList<String>();
                for (ItemStack s : OreDictionary.getOres((String)oreName)) {
                    String name = this.getItemName(s.func_77973_b());
                    if (name == null) continue;
                    names.add(name);
                }
                Matmos.ALIASLOGGER.debug("Items with oredict name " + oreName + ": " + Arrays.toString(names.toArray()));
                this.blockAliasMap.dealiasItemGroupToMinID(names);
                this.itemAliasMap.dealiasItemGroupToMinID(names);
            }
        }
        if (ConfigManager.getConfig().getBoolean("dealias.guessfromclass")) {
            this.itemAliasMap.guessAliases();
        }
        this.loadAliasFile(new File(configFolder, "alias.map"));
        this.blockAliasMap.compile();
        this.itemAliasMap.compile();
    }

    private List<AliasEntry> loadEntries(List<AliasEntry> entries, Path aliasDir, Path path, Set<Path> visited, boolean showWarnings) {
        try (FileReader reader = new FileReader(aliasDir.resolve(path).toFile());){
            int lineno = 0;
            for (String line : IOUtils.readLines((Reader)reader)) {
                if (!(line = line.trim()).startsWith("#") && !line.equals("")) {
                    if (line.startsWith(":")) {
                        String[] words = line.split(" ");
                        String[] directive = words[0].substring(1);
                        String argument = words.length > 1 ? words[1] : null;
                        switch (directive) {
                            case "import": {
                                Path linkedPath = MAtUtil.getParentSafe(path).resolve(Paths.get(argument, new String[0])).normalize();
                                if (!visited.contains(linkedPath)) {
                                    this.loadEntries(entries, aliasDir, linkedPath, visited, showWarnings);
                                    break;
                                }
                                Matmos.LOGGER.warn(String.format("%s:%d: Import cycle detected (%s->...->%s->%s)", path, lineno, linkedPath, path, linkedPath));
                                break;
                            }
                            case "disableWarnings": {
                                showWarnings = false;
                                break;
                            }
                            default: {
                                Matmos.LOGGER.warn(String.format("%s:%d: Invalid directive: %s", path, lineno, directive));
                                break;
                            }
                        }
                    } else {
                        String[] sides = line.split("=");
                        String key = sides[0];
                        if (sides.length == 2) {
                            if (!key.equals("") && !sides[1].equals("")) {
                                String[] values = sides[1].split(",");
                                if (values.length > 0) {
                                    for (String value : values) {
                                        entries.add(new AliasEntry(key, value, path.toString(), lineno, showWarnings));
                                    }
                                }
                            } else {
                                Matmos.LOGGER.warn(String.format("%s:%d: Assignment has empty side(s)", path, lineno));
                            }
                        } else {
                            Matmos.LOGGER.warn(String.format("%s:%d: Invalid alias assignment. Excepted 1 '=', got %d", path, lineno, sides.length - 1));
                        }
                    }
                }
                ++lineno;
            }
        }
        catch (FileNotFoundException e) {
            Matmos.LOGGER.warn("Alias file " + path + " is missing");
        }
        catch (IOException e) {
            Matmos.LOGGER.error("Error loading alias file " + path + ": " + e);
        }
        return entries;
    }

    private void loadAliasFile(File aliasFile) {
        Matmos.DEVLOGGER.info("Loading alias map " + aliasFile + "...");
        boolean hashMatch = false;
        if (Files.isRegularFile(aliasFile.toPath(), new LinkOption[0])) {
            try (InputStream is2 = Files.newInputStream(aliasFile.toPath(), new OpenOption[0]);){
                byte[] data = IOUtils.toByteArray((InputStream)is2);
                hashMatch = DigestUtils.sha256Hex((String)String.join((CharSequence)"\n", IOUtils.readLines((InputStream)new ByteArrayInputStream(data), (Charset)StandardCharsets.UTF_8))).equals(OLD_ALIAS_MAP_SHA256);
            }
            catch (IOException is2) {
                // empty catch block
            }
        }
        ConfigManager.getDefaultConfigHelper().createDefaultConfigFileIfMissing(aliasFile, hashMatch);
        Path aliasDir = MAtUtil.getParentSafe(aliasFile.toPath());
        List<AliasEntry> entries = this.loadEntries(new LinkedList<AliasEntry>(), aliasDir, aliasDir.relativize(aliasFile.toPath()), new HashSet<Path>(), true);
        this.blockAliasMap.addMappings(entries);
        this.itemAliasMap.addMappings(entries);
    }

    private String getItemName(Item item) {
        return MAtUtil.getItemName(item);
    }

    public int dealiasID(int alias, boolean isItem) {
        return isItem ? this.dealiasItemID(alias) : this.dealiasBlockID(alias);
    }

    public int dealiasBlockID(int alias) {
        return this.blockAliasMap.dealiasID(alias);
    }

    public int dealiasItemID(int alias) {
        return this.itemAliasMap.dealiasID(alias);
    }
}

