/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.scanners;

import eu.ha3.matmos.core.sheet.Sheet;
import eu.ha3.matmos.data.scanners.Scan;
import eu.ha3.matmos.data.scanners.ScannerModule;
import eu.ha3.matmos.util.ByteQueue;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import eu.ha3.matmos.util.MAtUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPane;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ScanAir
extends Scan {
    private int scanDistance;
    private int scanSize;
    private int startX;
    private int startY;
    private int startZ;
    private int xx;
    private int yy;
    private int zz;
    private boolean[] visited;
    ByteQueue floodQueue;
    ByteQueue solidQueue;
    ByteQueue solidInfoQueue;
    ByteQueue finalQueue;
    int skylitXMin;
    int skylitXMax;
    int skylitYMin;
    int skylitYMax;
    int skylitZMin;
    int skylitZMax;
    private int score;
    private Sheet raycastSheet;
    Stage stage = Stage.AIR1;
    private int AIR_COST;
    private int SOLID_COST;
    private int PANE_COST;
    byte START_NEARNESS;
    private int SCORE_THRESHOLD = 200;

    public ScanAir(Object raycastSheetObj) {
        this.raycastSheet = (Sheet)raycastSheetObj;
    }

    @Override
    void initScan(int x, int y, int z, int xsizeIn, int ysizeIn, int zsizeIn, int opspercallIn) {
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.xx = 0;
        this.yy = 0;
        this.zz = 0;
        this.score = 0;
        int newScanDistance = Math.min(Math.min((xsizeIn - 1) / 2, (ysizeIn - 1) / 2), (zsizeIn - 1) / 2);
        boolean reallocate = newScanDistance != this.scanDistance;
        this.scanDistance = newScanDistance;
        this.scanSize = this.scanDistance * 2 + 1;
        if (reallocate || this.visited == null) {
            this.visited = new boolean[this.scanSize * this.scanSize * this.scanSize];
        } else {
            for (int i = 0; i < this.visited.length; ++i) {
                this.visited[i] = false;
            }
        }
        if (reallocate || this.floodQueue == null) {
            this.floodQueue = new ByteQueue(this.scanDistance * this.scanDistance * 6 * 4);
        } else {
            this.floodQueue.clear();
        }
        if (reallocate || this.solidQueue == null) {
            this.solidQueue = new ByteQueue(this.scanDistance * this.scanDistance * 6 * 4);
        } else {
            this.solidQueue.clear();
        }
        if (reallocate || this.solidInfoQueue == null) {
            this.solidInfoQueue = new ByteQueue(this.scanDistance * this.scanDistance * 6);
        } else {
            this.solidInfoQueue.clear();
        }
        if (reallocate || this.finalQueue == null) {
            this.finalQueue = new ByteQueue(this.scanDistance * this.scanDistance * 6 * 4);
        } else {
            this.finalQueue.clear();
        }
        this.floodQueue.push4((byte)this.scanDistance, (byte)this.scanDistance, (byte)this.scanDistance, this.START_NEARNESS);
        this.skylitZMin = Integer.MAX_VALUE;
        this.skylitYMin = Integer.MAX_VALUE;
        this.skylitXMin = Integer.MAX_VALUE;
        this.skylitZMax = Integer.MIN_VALUE;
        this.skylitYMax = Integer.MIN_VALUE;
        this.skylitXMax = Integer.MIN_VALUE;
        this.stage = Stage.AIR1;
        this.AIR_COST = 5;
        this.SOLID_COST = 30;
        this.PANE_COST = 10;
        this.START_NEARNESS = (byte)80;
        this.finalProgress = 1;
    }

    @Override
    protected boolean doRoutine() {
        int ops = 0;
        int scanSize = this.scanDistance * 2 + 1;
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        byte[] p = new byte[4];
        block5: while (ops < this.opspercall && this.progress < this.finalProgress) {
            switch (this.stage) {
                case AIR1: 
                case AIR2: {
                    int wy;
                    if (this.floodQueue.pop4(p)) {
                        if (p[0] < 0 || p[0] >= scanSize || p[1] < 0 || p[1] >= scanSize || p[2] < 0 || p[2] >= scanSize) break;
                        int wx = this.startX - this.scanDistance + p[0];
                        wy = this.startY - this.scanDistance + p[1];
                        int wz = this.startZ - this.scanDistance + p[2];
                        if (p[3] <= 0 || !MAtUtil.isWithinBounds(new BlockPos(0, wy, 0)) || this.getVisited(p[0], p[1], p[2])) continue block5;
                        Block[] blockBuf = new Block[1];
                        int[] metaBuf = new int[1];
                        ((ScannerModule)this.pipeline).inputAndReturnBlockMeta(wx, wy, wz, blockBuf, metaBuf);
                        ++ops;
                        Block block = blockBuf[0];
                        int meta = metaBuf[0];
                        IBlockState bs = block.func_176203_a(meta);
                        BlockPos pos = new BlockPos(wx, wy, wz);
                        byte newN = (byte)(p[3] - this.AIR_COST);
                        if (ScanAir.isTransparentToSound(bs, (IBlockAccess)w, pos, false)) {
                            if (w.func_175710_j(pos) && block instanceof BlockAir) {
                                this.score += newN;
                                this.skylitXMin = Math.min(this.skylitXMin, wx);
                                this.skylitXMax = Math.max(this.skylitXMax, wx);
                                this.skylitYMin = Math.min(this.skylitYMin, wy);
                                this.skylitYMax = Math.max(this.skylitYMax, wy);
                                this.skylitZMin = Math.min(this.skylitZMin, wz);
                                this.skylitZMax = Math.max(this.skylitZMax, wz);
                                if (this.score > this.SCORE_THRESHOLD && !this.isTooHigh()) {
                                    this.stage = Stage.FINISH;
                                }
                            }
                            this.floodQueue.push4((byte)(p[0] - 1), p[1], p[2], newN);
                            this.floodQueue.push4((byte)(p[0] + 1), p[1], p[2], newN);
                            this.floodQueue.push4(p[0], (byte)(p[1] - 1), p[2], newN);
                            this.floodQueue.push4(p[0], (byte)(p[1] + 1), p[2], newN);
                            this.floodQueue.push4(p[0], p[1], (byte)(p[2] - 1), newN);
                            this.floodQueue.push4(p[0], p[1], (byte)(p[2] + 1), newN);
                        } else {
                            (this.stage == Stage.AIR1 ? this.solidQueue : this.finalQueue).push4(p[0], p[1], p[2], p[3]);
                            this.solidInfoQueue.push(this.isThinBlock(block) ? (byte)1 : 0);
                        }
                        this.setVisited(p[0], p[1], p[2], true);
                        break;
                    }
                    if (this.solidQueue.length() == 0) {
                        this.stage = Stage.FINISH;
                        break;
                    }
                    this.stage = Stage.SOLID;
                    break;
                }
                case SOLID: {
                    int wy;
                    if (this.solidQueue.pop4(p)) {
                        boolean isThin;
                        boolean bl = isThin = this.solidInfoQueue.pop() == 1;
                        wy = this.startY - this.scanDistance + p[1];
                        if (!MAtUtil.isWithinBounds(new BlockPos(0, wy, 0))) continue block5;
                        byte newN = (byte)(p[3] - (isThin ? this.PANE_COST : this.SOLID_COST));
                        this.floodQueue.push4((byte)(p[0] - 1), p[1], p[2], newN);
                        this.floodQueue.push4((byte)(p[0] + 1), p[1], p[2], newN);
                        this.floodQueue.push4(p[0], (byte)(p[1] - 1), p[2], newN);
                        this.floodQueue.push4(p[0], (byte)(p[1] + 1), p[2], newN);
                        this.floodQueue.push4(p[0], p[1], (byte)(p[2] - 1), newN);
                        this.floodQueue.push4(p[0], p[1], (byte)(p[2] + 1), newN);
                        this.setVisited(p[0], p[1], p[2], true);
                        break;
                    }
                    this.stage = Stage.AIR2;
                    break;
                }
                case FINISH: {
                    this.progress = 1;
                    this.pipeline.setValue(".__score", this.score);
                    int width = this.skylitXMax - this.skylitXMin;
                    int height = this.skylitYMax - this.skylitYMin;
                    int depth = this.skylitZMax - this.skylitZMin;
                    this.pipeline.setValue(".__width", width);
                    this.pipeline.setValue(".__height", height);
                    this.pipeline.setValue(".__depth", depth);
                    boolean tooHigh = this.isTooHigh();
                    boolean ownJudgement = this.score > this.SCORE_THRESHOLD && !tooHigh;
                    this.pipeline.setValue("._is_near_surface_own", ownJudgement ? 1 : 0);
                    boolean raycastJudgement = Integer.parseInt(this.raycastSheet.get("._is_near_surface_own")) > 0;
                    this.pipeline.setValue(".is_near_surface", ownJudgement | raycastJudgement ? 1 : 0);
                }
            }
        }
        return true;
    }

    private boolean isTooHigh() {
        int width = this.skylitXMax - this.skylitXMin;
        int depth = this.skylitZMax - this.skylitZMin;
        int height = this.skylitYMax - this.skylitYMin;
        return (float)(width * depth) < (float)(height * height) * 0.5f;
    }

    public static boolean isTransparentToSound(IBlockState bs, IBlockAccess blockAccess, BlockPos pos, boolean hitIfLiquid) {
        try {
            boolean result = !bs.func_177230_c().func_176209_a(bs, hitIfLiquid) || (!hitIfLiquid || !(bs.func_177230_c() instanceof BlockLiquid)) && (bs.func_185890_d(blockAccess, pos) == null || bs.func_177230_c() instanceof BlockLeaves);
            return result;
        }
        catch (Exception e) {
            IDontKnowHowToCode.warnOnce("Exception in isTransparentToSound, checking block of class " + bs.func_177230_c().getClass() + ": " + e.getMessage());
            return false;
        }
    }

    private boolean isThinBlock(Block block) {
        return block instanceof BlockDoor || block instanceof BlockGlass || block instanceof BlockPane;
    }

    private boolean getVisited(int x, int y, int z) {
        return this.visited[x * this.scanSize * this.scanSize + y * this.scanSize + z];
    }

    private boolean setVisited(int x, int y, int z, boolean newValue) {
        this.visited[x * this.scanSize * this.scanSize + y * this.scanSize + z] = newValue;
        return true;
    }

    static enum Stage {
        AIR1,
        SOLID,
        AIR2,
        FINISH;

    }
}

