/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules.world;

import eu.ha3.matmos.ConfigManager;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.data.modules.Module;
import eu.ha3.matmos.data.modules.ModuleProcessor;
import eu.ha3.matmos.util.MAtUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldInfo;

public class ModuleWorld
extends ModuleProcessor
implements Module {
    float rainStrengthThreshold;
    int[] celestialAngleToTime = ModuleWorld.constructCelestialAngleToTimeTable();

    public ModuleWorld(DataPackage data) {
        super(data, "w_general");
        this.rainStrengthThreshold = ConfigManager.getConfig().getFloat("rain.strengththreshold");
    }

    private static int[] constructCelestialAngleToTimeTable() {
        int[] angleToTime = new int[1000];
        WorldProviderSurface p = new WorldProviderSurface();
        int t = 23999;
        while (t >= 0) {
            float angle = p.func_76563_a((long)t, 0.0f);
            angleToTime[(int)(angle * (float)angleToTime.length)] = t--;
        }
        return angleToTime;
    }

    @Override
    protected void doProcess() {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        EntityPlayer player = this.getPlayer();
        WorldInfo info = w.func_72912_H();
        BlockPos pos = MAtUtil.getPlayerPos();
        Biome biome = w.func_180494_b(pos);
        this.setValue("time_modulo24k", this.invCalculateCelestialAngle(w.field_73011_w.func_76563_a(info.func_76073_f(), 0.0f)));
        this.setValue("rain", this.rainStrengthThreshold == -1.0f ? w.func_72896_J() : w.func_72867_j(0.0f) > this.rainStrengthThreshold);
        this.setValue("thunder", info.func_76061_m());
        this.setValue("thunder", w.func_72819_i(0.0f) > 0.9f);
        this.setValue("dimension", player.field_71093_bK);
        this.setValue("light_subtracted", w.func_175657_ab());
        this.setValue("remote", w.field_72995_K);
        this.setValue("moon_phase", w.func_72853_d());
        this.setValue("can_rain_on", MAtUtil.canSeeSky(pos));
        this.setValue("can_snow_here", w.field_73011_w.canSnowAt(pos, false));
        this.setValue("biome_can_rain", biome.func_76738_d());
        this.setValue("biome_is_snowy", biome.func_76746_c());
        this.setValue("biome_temperature", Math.round(biome.func_180626_a(pos) * 1000.0f));
        this.setValue("biome_rainfall", Math.round(biome.func_76727_i() * 1000.0f));
        this.setValue("can_rain_here", biome.func_76738_d() && biome.func_180626_a(pos) > 0.15f);
        this.setValue("rain_force1k", Math.round(w.func_72867_j(0.0f) * 1000.0f));
        this.setValue("thunder_force1k", Math.round(w.func_72819_i(0.0f) * 1000.0f));
    }

    private int invCalculateCelestialAngle(float x) {
        int prev;
        int prevIndex = (int)((x %= 1.0f) * (float)this.celestialAngleToTime.length);
        float alpha = x * (float)this.celestialAngleToTime.length - (float)Math.floor(x * (float)this.celestialAngleToTime.length);
        int nextIndex = prevIndex + 1 < this.celestialAngleToTime.length ? prevIndex + 1 : 0;
        int next = this.celestialAngleToTime[nextIndex];
        if (next < (prev = this.celestialAngleToTime[prevIndex])) {
            next = 24000;
        }
        return (int)((1.0f - alpha) * (float)prev + alpha * (float)next);
    }
}

