/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.data.modules;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.GenericSheet;
import eu.ha3.matmos.core.sheet.SheetDataPackage;
import eu.ha3.matmos.data.IDataCollector;
import eu.ha3.matmos.data.IDataGatherer;
import eu.ha3.matmos.data.modules.Module;
import eu.ha3.matmos.data.modules.ModuleContainer;
import eu.ha3.matmos.data.modules.ModuleEntity;
import eu.ha3.matmos.data.modules.ModuleMetaOptions;
import eu.ha3.matmos.data.modules.ModuleServerInfo;
import eu.ha3.matmos.data.modules.ModuleTimedRandom;
import eu.ha3.matmos.data.modules.PassOnceModule;
import eu.ha3.matmos.data.modules.ProcessorModel;
import eu.ha3.matmos.data.modules.items.ModulePotionDuration;
import eu.ha3.matmos.data.modules.items.ModulePotionStrength;
import eu.ha3.matmos.data.modules.legacy.ModuleDice;
import eu.ha3.matmos.data.modules.legacy.ModuleLegacy;
import eu.ha3.matmos.data.modules.legacy.ModuleLegacyColumn;
import eu.ha3.matmos.data.modules.legacy.ModuleLegacyHitscan;
import eu.ha3.matmos.data.modules.legacy.ModuleModData;
import eu.ha3.matmos.data.modules.mount.ModuleHorse;
import eu.ha3.matmos.data.modules.mount.ModuleRiding;
import eu.ha3.matmos.data.modules.mount.ModuleRidingMotion;
import eu.ha3.matmos.data.modules.player.ModuleAction;
import eu.ha3.matmos.data.modules.player.ModuleArmour;
import eu.ha3.matmos.data.modules.player.ModuleArmourEnchantment;
import eu.ha3.matmos.data.modules.player.ModuleHeldEnchantment;
import eu.ha3.matmos.data.modules.player.ModuleHitscan;
import eu.ha3.matmos.data.modules.player.ModuleInventory;
import eu.ha3.matmos.data.modules.player.ModuleLeashing;
import eu.ha3.matmos.data.modules.player.ModuleMotion;
import eu.ha3.matmos.data.modules.player.ModulePlayerStats;
import eu.ha3.matmos.data.modules.player.ModuleStats;
import eu.ha3.matmos.data.modules.world.ModuleBiome;
import eu.ha3.matmos.data.modules.world.ModuleCollission;
import eu.ha3.matmos.data.modules.world.ModuleColumn;
import eu.ha3.matmos.data.modules.world.ModuleDebug;
import eu.ha3.matmos.data.modules.world.ModuleLighting;
import eu.ha3.matmos.data.modules.world.ModulePosition;
import eu.ha3.matmos.data.modules.world.ModuleWorld;
import eu.ha3.matmos.data.scanners.Progress;
import eu.ha3.matmos.data.scanners.ScanAir;
import eu.ha3.matmos.data.scanners.ScanRaycast;
import eu.ha3.matmos.data.scanners.ScanVolumetric;
import eu.ha3.matmos.data.scanners.ScannerModule;
import eu.ha3.matmos.lib.eu.ha3.easy.StopWatchStatistic;
import eu.ha3.matmos.lib.eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ModuleRegistry
implements IDataCollector,
IDataGatherer {
    private final Matmos mod;
    private DataPackage data;
    private int ticksPassed;
    private StopWatchStatistic watch = new StopWatchStatistic();
    public static final String LEGACY_PREFIX = "legacy";
    private final Map<String, Module> modules;
    private final Map<String, Set<String>> passOnceModules;
    private final Set<String> passOnceSubmodules;
    private final Set<String> requiredModules;
    private final Set<String> iteratedThroughModules;
    private final Map<String, Set<String>> moduleStack;
    private ScannerModule largeScanner;
    private ScannerModule mediumScanner;
    private ScannerModule raycastScanner;

    public ModuleRegistry(Matmos mAtmosHaddon) {
        this.mod = mAtmosHaddon;
        this.modules = new TreeMap<String, Module>();
        this.passOnceModules = new TreeMap<String, Set<String>>();
        this.passOnceSubmodules = new HashSet<String>();
        this.requiredModules = new TreeSet<String>();
        this.iteratedThroughModules = new TreeSet<String>();
        this.moduleStack = new TreeMap<String, Set<String>>();
    }

    private void addModule(Module module) {
        this.modules.put(module.getName(), module);
        if (module instanceof PassOnceModule) {
            this.passOnceModules.put(module.getName(), ((PassOnceModule)module).getSubModules());
            this.passOnceSubmodules.addAll(((PassOnceModule)module).getSubModules());
        }
    }

    private void addModule(Module module, int cycle) {
        if (module instanceof ProcessorModel) {
            ((ProcessorModel)((Object)module)).setInterval(cycle - 1);
        }
        this.addModule(module);
    }

    public void load() {
        this.data = new SheetDataPackage(GenericSheet.class);
        this.addModule(new ModuleLegacyColumn(this.data), 0);
        this.addModule(new ModuleLegacyHitscan(this.data), 0);
        this.addModule(new ModuleDice(this.data), 0);
        this.addModule(new ModuleLegacy(this.data), 0);
        this.addModule(new ModuleModData(this.data, this.mod), 0);
        this.addModule(new ModuleColumn(this.data), 0);
        this.addModule(new ModuleLighting(this.data), 0);
        this.addModule(new ModulePosition(this.data), 0);
        this.addModule(new ModuleContainer(this.data), 0);
        this.addModule(new ModuleAction(this.data), 0);
        this.addModule(new ModuleArmour(this.data), 0);
        this.addModule(new ModulePlayerStats(this.data), 0);
        this.addModule(new ModuleInventory(this.data), 0);
        this.addModule(new ModuleMotion(this.data), 0);
        this.addModule(new ModuleStats(this.data), 0);
        this.addModule(new ModuleRiding(this.data), 0);
        this.addModule(new ModuleHorse(this.data), 0);
        this.addModule(new ModuleRidingMotion(this.data), 0);
        this.addModule(new ModuleTimedRandom(this.data), 20);
        this.addModule(new ModuleBiome(this.data, this.mod), 20);
        this.addModule(new ModuleWorld(this.data), 0);
        this.addModule(new ModuleMetaOptions(this.data, this.mod), 200);
        this.addModule(new ModuleServerInfo(this.data), 200);
        this.addModule(new ModuleEntity(this.data, this, "detect_mindist", "detect_radius", 256, 2, 5, 10, 20, 50));
        for (int i = 0; i < 4; ++i) {
            this.addModule(new ModuleArmourEnchantment(this.data, i));
        }
        this.addModule(new ModuleHeldEnchantment(this.data), 0);
        this.addModule(new ModuleHitscan(this.data), 0);
        this.addModule(new ModuleLeashing(this.data), 0);
        this.addModule(new ModulePotionDuration(this.data), 0);
        this.addModule(new ModulePotionStrength(this.data), 0);
        this.addModule(new ModuleCollission(this.data), 0);
        this.largeScanner = new ScannerModule(ScanVolumetric.class, this.data, "_POM__scan_large", "scan_large", Arrays.asList(ScannerModule.Submodule.THOUSAND, ScannerModule.Submodule.ABOVE, ScannerModule.Submodule.BELOW), 8, 10, 20, 64, 32, 64, 2048);
        this.addModule(this.largeScanner);
        this.addModule(new ScannerModule(ScanRaycast.class, this.data, "_POM__scan_raycast", "scan_raycast", Arrays.asList(ScannerModule.Submodule.WEIGHTED, ScannerModule.Submodule.ABOVE, ScannerModule.Submodule.BELOW), -1, -1, -1, 100, 100, 100, 10));
        this.mediumScanner = new ScannerModule(ScanAir.class, this.data.getSheet("scan_raycast"), this.data, "_POM__scan_air", "scan_air", Arrays.asList(ScannerModule.Submodule.THOUSAND), -1, -1, 20, 31, 31, 31, 3844);
        this.addModule(this.mediumScanner);
        this.addModule(new ScannerModule(ScanVolumetric.class, this.data, "_POM__scan_small", "scan_small", Arrays.asList(ScannerModule.Submodule.THOUSAND), -1, -1, 2, 16, 8, 16, 1024));
        this.addModule(new ModuleDebug(this.data));
        Matmos.DEVLOGGER.info("Modules initialized: " + Arrays.toString(new TreeSet<String>(this.modules.keySet()).toArray()));
    }

    public DataPackage getData() {
        return this.data;
    }

    @Override
    public void process() {
        TimeStatistic stat = new TimeStatistic();
        for (String requiredModule : this.iteratedThroughModules) {
            this.watch.reset();
            try {
                this.modules.get(requiredModule).process();
            }
            catch (Exception e) {
                IDontKnowHowToCode.whoops__printExceptionToChat(this.mod.getChatter(), e, requiredModule.hashCode());
            }
            this.watch.stop();
            if (this.watch.getMilliseconds() <= 50L || !this.mod.isDebugMode()) continue;
            Matmos.LOGGER.warn("Module " + requiredModule + " took " + stat.getMilliseconds() + "ms!!!");
        }
        ++this.ticksPassed;
    }

    @Override
    public boolean requires(String moduleName) {
        return this.requiredModules.contains(moduleName);
    }

    @Override
    public void addModuleStack(String name, Set<String> requiredModules) {
        HashSet<String> deltaModules = new HashSet<String>();
        HashSet<String> actualModules = new HashSet<String>();
        for (String module : requiredModules) {
            if (!module.endsWith("_delta")) continue;
            deltaModules.add(module);
            actualModules.add(module.substring(0, module.length() - "_delta".length()));
        }
        requiredModules.removeAll(deltaModules);
        requiredModules.addAll(actualModules);
        HashSet<String> missingModules = new HashSet<String>();
        for (String module : requiredModules) {
            if (this.modules.containsKey(module) || this.passOnceSubmodules.contains(module)) continue;
            if (!ModuleRegistry.isDynamicModule(module)) {
                Matmos.LOGGER.error("Stack " + name + " requires missing module " + module);
            }
            missingModules.add(module);
        }
        for (String missingModule : missingModules) {
            requiredModules.remove(missingModule);
        }
        this.moduleStack.put(name, requiredModules);
        this.recomputeModuleStack();
    }

    private static boolean isDynamicModule(String module) {
        return module.equals("_DYNAMIC");
    }

    @Override
    public void removeModuleStack(String name) {
        this.moduleStack.remove(name);
        this.recomputeModuleStack();
    }

    public void forceRecomputeModuleStack_debugModeChanged() {
        this.recomputeModuleStack();
    }

    private void recomputeModuleStack() {
        if (this.mod.isDebugMode()) {
            this.requiredModules.clear();
            this.iteratedThroughModules.clear();
            this.requiredModules.addAll(this.modules.keySet());
            this.requiredModules.removeAll(this.passOnceModules.keySet());
            this.requiredModules.addAll(this.passOnceSubmodules);
            this.iteratedThroughModules.addAll(this.modules.keySet());
            return;
        }
        this.requiredModules.clear();
        this.iteratedThroughModules.clear();
        for (Set<String> set : this.moduleStack.values()) {
            this.requiredModules.addAll(set);
            this.iteratedThroughModules.addAll(set);
        }
        for (Map.Entry entry : this.passOnceModules.entrySet()) {
            if (Collections.disjoint((Collection)entry.getValue(), this.iteratedThroughModules)) continue;
            this.iteratedThroughModules.removeAll((Collection)entry.getValue());
            this.iteratedThroughModules.add((String)entry.getKey());
        }
    }

    public Progress getLargeScanProgress() {
        return this.largeScanner;
    }
}

