/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sound;

import eu.ha3.matmos.core.SoundRelay;
import eu.ha3.matmos.core.sound.LoopingStreamedSoundManager;
import eu.ha3.matmos.core.sound.SoundHelper;
import eu.ha3.matmos.util.MAtUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class SoundHelperRelay
extends SoundHelper
implements SoundRelay {
    private static int streamingToken;
    protected final Map<String, Integer> pathToToken = new HashMap<String, Integer>();
    private final Map<String, String> paths = new HashMap<String, String>();

    public SoundHelperRelay(LoopingStreamedSoundManager soundManager) {
        super(soundManager);
    }

    @Override
    public void routine() {
        super.routine();
    }

    @Override
    public void cacheSound(String path) {
        String dotted = path.replace(".ogg", "").replace('/', '.').replaceAll("[0-9]", "");
        this.paths.put(path, dotted);
    }

    @Override
    public void playSound(String path, float volume, float pitch, int meta) {
        EntityPlayer e = MAtUtil.getPlayer();
        if (meta <= 0) {
            this.playStereo(this.paths.get(path), volume, pitch);
        } else {
            this.playMono(this.paths.get(path), e.field_70165_t, e.field_70163_u, e.field_70161_v, volume, pitch);
        }
    }

    @Override
    public void playSoundEvent(String path, float x, float y, float z, float volume, float pitch) {
        this.playMono(path, x, y, z, volume, pitch);
    }

    @Override
    public int getNewStreamingToken() {
        return streamingToken++;
    }

    @Override
    public boolean setupStreamingToken(int token, String path, float pitch, boolean isLooping, boolean usesPause, boolean underwater) {
        this.registerStreaming("" + token, path, 1.0f, pitch, isLooping, usesPause, underwater, this);
        return true;
    }

    @Override
    public void setVolume(int token, float newVolume, float fadeDuration) {
        super.setVolume("" + token, newVolume, fadeDuration);
    }

    @Override
    public void eraseStreamingToken(int token) {
    }

    @Override
    public int getStreamingTokenFor(String path, float volume, float pitch, boolean isLooping, boolean usesPause, boolean underwater) {
        if (this.pathToToken.containsKey(path)) {
            return this.pathToToken.get(path);
        }
        int token = this.getNewStreamingToken();
        this.registerStreaming("" + token, path, volume, pitch, isLooping, usesPause, underwater, this);
        this.pathToToken.put(path, token);
        return token;
    }
}

