/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sound;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.StreamHandle;
import eu.ha3.matmos.core.expansion.Stable;
import eu.ha3.matmos.core.sound.LoopingStreamedSoundManager;
import eu.ha3.matmos.core.sound.NoAttenuationMovingSound;
import eu.ha3.matmos.core.sound.NoAttenuationSound;
import eu.ha3.matmos.core.sound.SoundCapabilities;
import eu.ha3.matmos.core.sound.SoundHelperRelay;
import eu.ha3.matmos.util.IDontKnowHowToCode;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.ResourceLocation;

public class SoundHelper
implements SoundCapabilities,
Stable {
    private LoopingStreamedSoundManager soundManager;
    protected final Map<String, StreamHandle<NoAttenuationMovingSound>> streaming = new LinkedHashMap<String, StreamHandle<NoAttenuationMovingSound>>();
    private float volumeModulator;
    private boolean isInterrupt;
    private boolean isActivated;

    public SoundHelper(LoopingStreamedSoundManager soundManager) {
        this.soundManager = soundManager;
    }

    @Override
    public void playMono(String event, double xx, double yy, double zz, float volume, float pitch) {
        if (this.isInterrupt) {
            return;
        }
        this.playUnattenuatedSound(xx, yy, zz, event, volume * this.volumeModulator, pitch);
    }

    @Override
    public void playStereo(String event, float volume, float pitch) {
        if (this.isInterrupt) {
            return;
        }
        EntityPlayerSP e = Minecraft.func_71410_x().field_71439_g;
        this.playUnattenuatedSound(e.field_70165_t, e.field_70163_u + 2048.0, e.field_70161_v, event, volume * this.volumeModulator, pitch);
    }

    private void playUnattenuatedSound(double xx, double yy, double zz, String loc, float volume, float pitch) {
        NoAttenuationSound nas = new NoAttenuationSound(new ResourceLocation(loc), volume, pitch, (float)xx, (float)yy, (float)zz);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)nas);
    }

    @Override
    public void registerStreaming(String customName, String path, float volume, float pitch, boolean isLooping, boolean usesPause, boolean underwater, SoundHelperRelay relay) {
        if (this.isInterrupt) {
            return;
        }
        String loc = path.replace(".ogg", "").replace('/', '.').replaceAll("[0-9]", "");
        NoAttenuationMovingSound nams = new NoAttenuationMovingSound(new ResourceLocation(loc), volume, pitch, isLooping, usesPause, underwater);
        this.streaming.put(customName, StreamHandle.of(nams, relay));
    }

    @Override
    public void playStreaming(String customName, float fadeIn) {
        if (this.isInterrupt) {
            return;
        }
        if (!this.streaming.containsKey(customName)) {
            IDontKnowHowToCode.warnOnce("Tried to play missing stream " + customName);
            return;
        }
        this.setVolume(customName, this.streaming.get(customName).getSound().func_147653_e(), fadeIn);
    }

    @Override
    public void stopStreaming(String customName, float fadeOut) {
        if (this.isInterrupt) {
            return;
        }
        if (!this.streaming.containsKey(customName)) {
            IDontKnowHowToCode.warnOnce("Tried to stop missing stream " + customName);
            return;
        }
        this.setVolume(customName, 0.0f, fadeOut);
    }

    public void routine() {
        for (StreamHandle<NoAttenuationMovingSound> handle : this.streaming.values()) {
            float newVolume = handle.getLargestVolumeCommandThisTick();
            if (newVolume >= 0.0f) {
                float fade = handle.getFadeOfLargestVolumeCommandThisTick();
                NoAttenuationMovingSound sound = handle.getSound();
                if (newVolume > 0.0f && sound.getTargetVolume() != newVolume) {
                    boolean reuse = false;
                    boolean previousIsDonePlaying = sound.func_147667_k();
                    if (previousIsDonePlaying) {
                        sound = sound.copy();
                        handle.setSound(sound);
                    } else {
                        reuse = true;
                    }
                    sound.setVolume(newVolume, fade);
                    sound.applyVolume(this.volumeModulator);
                    boolean notYetPlayed = sound.popNotYetPlayed();
                    Matmos.DEBUGLOGGER.debug("playStreaming " + sound.func_147650_b() + " (reuse=" + reuse + ", notYetPlayed = " + notYetPlayed + ", donePlaying=" + previousIsDonePlaying + ")");
                    if (notYetPlayed) {
                        try {
                            this.soundManager.playSound(sound);
                        }
                        catch (Exception e) {
                            Matmos.LOGGER.warn("There was an exception when trying to start stream " + sound.func_147650_b() + ": " + e.getMessage());
                        }
                    }
                } else if (newVolume == 0.0f && sound.getTargetVolume() != newVolume) {
                    Matmos.DEBUGLOGGER.debug("stopStreaming " + sound.func_147650_b());
                    sound.stop(fade);
                }
            }
            handle.resetLargestVolumeCommandThisTick();
        }
    }

    public void setVolume(String customName, float newVolume, float fade) {
        if (this.isInterrupt) {
            return;
        }
        if (!this.streaming.containsKey(customName)) {
            IDontKnowHowToCode.warnOnce("Tried to set volume of missing stream " + customName);
            return;
        }
        this.streaming.get(customName).setVolume(newVolume, fade);
    }

    @Override
    public void stop() {
        if (this.isInterrupt) {
            return;
        }
        for (StreamHandle<NoAttenuationMovingSound> handle : this.streaming.values()) {
            handle.getSound().dispose();
        }
    }

    @Override
    public void applyVolume(float volumeMod) {
        this.volumeModulator = volumeMod;
        for (StreamHandle<NoAttenuationMovingSound> handle : this.streaming.values()) {
            handle.getSound().applyVolume(volumeMod);
        }
    }

    @Override
    public void interrupt() {
        this.isInterrupt = true;
    }

    @Override
    public void cleanUp() {
        if (this.isInterrupt) {
            return;
        }
        for (StreamHandle<NoAttenuationMovingSound> handle : this.streaming.values()) {
            handle.getSound().dispose();
        }
        this.streaming.clear();
    }

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    @Override
    public void activate() {
        if (this.isActivated) {
            return;
        }
        this.isActivated = true;
    }

    @Override
    public void deactivate() {
        if (!this.isActivated) {
            return;
        }
        this.streaming.keySet().forEach(s -> this.stopStreaming((String)s, 2.0f));
        this.isActivated = false;
    }

    @Override
    public void dispose() {
        this.cleanUp();
    }
}

