/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sound;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.sound.SoundManagerListener;
import eu.ha3.matmos.core.sound.StreamingSound;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsTickEvents;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import paulscode.sound.SoundSystem;

public class LoopingStreamedSoundManager
implements SupportsTickEvents,
SoundManagerListener {
    private Set<ResourceLocation> UNABLE_TO_PLAY = new HashSet<ResourceLocation>();
    private final Map<String, StreamingSound> playingSounds = new ConcurrentHashMap<String, StreamingSound>();
    private final Map<StreamingSound, String> invPlayingSounds = new ConcurrentHashMap<StreamingSound, String>();

    @Override
    public void onTick() {
        for (StreamingSound streamingSound : this.invPlayingSounds.keySet()) {
            ITickableSound itickablesound = streamingSound.asTickable();
            itickablesound.func_73660_a();
            if (itickablesound.func_147667_k()) {
                this.stopSound(streamingSound);
                continue;
            }
            String s = this.invPlayingSounds.get(streamingSound);
            this.getSoundSystem().setVolume(s, this.getClampedVolume(streamingSound));
            this.getSoundSystem().setPitch(s, this.getClampedPitch(streamingSound));
            this.getSoundSystem().setPosition(s, itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
        }
    }

    public void playSound(StreamingSound streamingSound) {
        if (this.isSoundManagerLoaded()) {
            if (streamingSound == null) {
                return;
            }
            ITickableSound p_sound = streamingSound.asTickable();
            SoundEventAccessor soundeventaccessor = p_sound.func_184366_a(this.getSoundHandler());
            ResourceLocation resourcelocation = p_sound.func_147650_b();
            if (soundeventaccessor == null) {
                if (this.UNABLE_TO_PLAY.add(resourcelocation)) {
                    Matmos.LOGGER.warn("Unable to play unknown soundEvent: {}", (Object)resourcelocation);
                }
            } else if (this.getSoundSystem().getMasterVolume() <= 0.0f) {
                Matmos.DEBUGLOGGER.debug("Skipped playing soundEvent: {}, master volume was zero", (Object)resourcelocation);
            } else {
                Sound sound = p_sound.func_184364_b();
                if (sound == SoundHandler.field_147700_a) {
                    if (this.UNABLE_TO_PLAY.add(resourcelocation)) {
                        Matmos.LOGGER.warn("Unable to play empty soundEvent: {}", (Object)resourcelocation);
                    }
                } else {
                    float f3 = p_sound.func_147653_e();
                    float f = 16.0f;
                    if (f3 > 1.0f) {
                        f *= f3;
                    }
                    SoundCategory soundcategory = p_sound.func_184365_d();
                    float f1 = this.getClampedVolume(streamingSound);
                    float f2 = this.getClampedPitch(streamingSound);
                    if (f1 == 0.0f) {
                        Matmos.DEBUGLOGGER.debug("Skipped playing sound {}, volume was zero.", (Object)sound.func_188719_a());
                    } else {
                        boolean flag = p_sound.func_147657_c() && p_sound.func_147652_d() == 0;
                        String s = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
                        ResourceLocation resourcelocation1 = sound.func_188721_b();
                        if (sound.func_188723_h()) {
                            this.getSoundSystem().newStreamingSource(false, s, SoundManager.func_148612_a((ResourceLocation)resourcelocation1), resourcelocation1.toString(), flag, p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i(), p_sound.func_147656_j().func_148586_a(), f);
                        } else {
                            this.getSoundSystem().newSource(false, s, SoundManager.func_148612_a((ResourceLocation)resourcelocation1), resourcelocation1.toString(), flag, p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i(), p_sound.func_147656_j().func_148586_a(), f);
                        }
                        Matmos.DEBUGLOGGER.debug("Playing sound {} for event {} as channel {}", (Object)sound.func_188719_a(), (Object)resourcelocation, (Object)s);
                        this.getSoundSystem().setPitch(s, f2);
                        this.getSoundSystem().setVolume(s, f1);
                        this.getSoundSystem().play(s);
                        this.playingSounds.put(s, streamingSound);
                        this.invPlayingSounds.put(streamingSound, s);
                    }
                }
            }
        }
    }

    public void stopSound(StreamingSound sound) {
        String s;
        if (this.isSoundManagerLoaded() && (s = this.invPlayingSounds.get(sound)) != null) {
            this.getSoundSystem().stop(s);
            this.playingSounds.remove(s);
            this.invPlayingSounds.remove(sound);
        }
    }

    private SoundManager getSoundManager() {
        return this.getSoundHandler().field_147694_f;
    }

    private SoundHandler getSoundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    private SoundSystem getSoundSystem() {
        return this.getSoundManager().field_148620_e;
    }

    private boolean isSoundManagerLoaded() {
        return this.getSoundManager().field_148617_f;
    }

    private float getClampedPitch(StreamingSound sound) {
        return MathHelper.func_76131_a((float)sound.asTickable().func_147655_f(), (float)0.5f, (float)2.0f);
    }

    private float getClampedVolume(StreamingSound sound) {
        return MathHelper.func_76131_a((float)(sound.asTickable().func_147653_e() * this.getCategoryVolume(sound.asTickable().func_184365_d())), (float)0.0f, (float)1.0f);
    }

    private float getCategoryVolume(SoundCategory category) {
        return this.getSoundManager().func_188769_a(category);
    }

    @Override
    public void onStopAllSounds() {
    }

    public void stopAllSounds() {
        for (StreamingSound sound : this.playingSounds.values()) {
            sound.interrupt();
            this.stopSound(sound);
        }
    }

    public void dispose() {
        this.stopAllSounds();
        this.playingSounds.clear();
        this.invPlayingSounds.clear();
    }

    @Override
    public void onPauseAllSounds(boolean pause) {
        for (String sound : this.playingSounds.keySet()) {
            if (pause) {
                this.getSoundSystem().pause(sound);
                continue;
            }
            this.getSoundSystem().play(sound);
        }
    }
}

