/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.sheet;

import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.Sheet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SheetDataPackage
implements DataPackage {
    private final Map<String, Sheet> sheets;
    private final Class<? extends Sheet> sheetType;
    Set<Integer> referencedBlockIDs = new HashSet<Integer>();
    Set<Integer> referencedItemIDs = new HashSet<Integer>();

    public SheetDataPackage(Class<? extends Sheet> sheetType) {
        this.sheets = new HashMap<String, Sheet>();
        this.sheetType = sheetType;
    }

    @Override
    public Sheet getSheet(String name) {
        if (!this.sheets.containsKey(name)) {
            try {
                this.sheets.put(name, this.sheetType.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.sheets.get(name);
    }

    @Override
    public Set<String> getSheetNames() {
        return this.sheets.keySet();
    }

    @Override
    public void clear() {
        this.sheets.clear();
    }

    @Override
    public void clearContents() {
        for (Sheet sheet : this.sheets.values()) {
            sheet.clear();
        }
    }

    public void addReferencedIDs(List<Integer> newReferencedBlockIDs, List<Integer> newReferencedItemIDs) {
        this.referencedBlockIDs.addAll(newReferencedBlockIDs);
        this.referencedItemIDs.addAll(newReferencedItemIDs);
    }

    public boolean isIDReferenced(int id, boolean isItem) {
        return (isItem ? this.referencedItemIDs : this.referencedBlockIDs).contains(id);
    }
}

