/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.logic;

import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.core.Dependable;
import eu.ha3.matmos.core.MultistateComponent;
import eu.ha3.matmos.core.Named;
import eu.ha3.matmos.core.Provider;
import eu.ha3.matmos.core.logic.Condition;
import eu.ha3.matmos.core.logic.VisualizedSpecialDependencies;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Junction
extends MultistateComponent
implements Dependable,
VisualizedSpecialDependencies {
    private final List<String> yes;
    private final List<String> no;
    private final Provider<Condition> provider;
    private final Collection<String> dependencies;
    private final boolean inverted;

    public Junction(String name, Provider<Condition> provider, List<String> yes, List<String> no, boolean inverted) {
        super(name);
        this.provider = provider;
        this.yes = yes;
        this.no = no;
        this.inverted = inverted;
        this.dependencies = new TreeSet<String>();
        this.dependencies.addAll(yes);
        this.dependencies.addAll(no);
    }

    public Junction(String name, Provider<Condition> provider, List<String> yes, List<String> no) {
        this(name, provider, yes, no, false);
    }

    @Override
    public void evaluate() {
        boolean pre = this.isActive;
        this.isActive = this.testIfTrue();
        if (this.inverted) {
            boolean bl = this.isActive = !this.isActive;
        }
        if (pre != this.isActive) {
            Matmos.DEBUGLOGGER.debug("S: " + this.getName() + " -> " + this.isActive);
            this.incrementVersion();
        }
    }

    private boolean testIfTrue() {
        boolean isTrue = true;
        Iterator<String> iterYes = this.yes.iterator();
        while (isTrue && iterYes.hasNext()) {
            String yes = iterYes.next();
            if (this.provider.exists(yes) && this.provider.get(yes).isActive()) continue;
            isTrue = false;
        }
        if (!isTrue) {
            return false;
        }
        Iterator<String> iterNo = this.no.iterator();
        while (isTrue && iterNo.hasNext()) {
            String no = iterNo.next();
            if (this.provider.exists(no) && !this.provider.get(no).isActive()) continue;
            isTrue = false;
        }
        return isTrue;
    }

    @Override
    public Collection<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getFeed() {
        return "";
    }

    @Override
    public Collection<String> getSpecialDependencies(String type) {
        if (type.equals("yes")) {
            return this.yes;
        }
        if (type.equals("no")) {
            return this.no;
        }
        return new HashSet<String>();
    }

    public Named getInverted() {
        return new Junction("!" + this.getName(), this.provider, this.yes, this.no, !this.inverted);
    }
}

