/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.core.expansion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.ha3.matmos.ConfigManager;
import eu.ha3.matmos.Matmos;
import eu.ha3.matmos.ResourcePackDealer;
import eu.ha3.matmos.core.expansion.Expansion;
import eu.ha3.matmos.core.expansion.ExpansionIdentity;
import eu.ha3.matmos.core.expansion.SoundpackIdentity;
import eu.ha3.matmos.core.expansion.VolumeUpdatable;
import eu.ha3.matmos.core.expansion.agents.JsonLoadingAgent;
import eu.ha3.matmos.core.expansion.agents.LegacyXMLLoadingAgent;
import eu.ha3.matmos.core.sheet.DataPackage;
import eu.ha3.matmos.core.sheet.SheetDataPackage;
import eu.ha3.matmos.core.sound.LoopingStreamedSoundManager;
import eu.ha3.matmos.data.IDataCollector;
import eu.ha3.matmos.dealias.IDDealiaser;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsFrameEvents;
import eu.ha3.matmos.lib.eu.ha3.mc.haddon.supporting.SupportsTickEvents;
import eu.ha3.matmos.util.MAtUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ExpansionManager
implements VolumeUpdatable,
SupportsTickEvents,
SupportsFrameEvents {
    private final LoopingStreamedSoundManager soundManager;
    private final File userconfigFolder;
    private final ResourcePackDealer dealer = new ResourcePackDealer();
    private final List<SoundpackIdentity> soundpackIdentities = new ArrayList<SoundpackIdentity>();
    private final Map<String, Expansion> expansions = new HashMap<String, Expansion>();
    private static IDDealiaser dealiasMap;
    private DataPackage data;
    private float volume = 1.0f;
    List<Integer> dimensionList;
    boolean dimensionListIsWhitelist;
    private Optional<Integer> lastDimension = Optional.empty();
    private IDataCollector collector;

    public ExpansionManager(File userconfigFolder, File aliasFolder, LoopingStreamedSoundManager soundManager) {
        this.userconfigFolder = userconfigFolder;
        this.soundManager = soundManager;
        if (!this.userconfigFolder.exists()) {
            this.userconfigFolder.mkdirs();
        }
        dealiasMap = new IDDealiaser(aliasFolder);
        if (this.dimensionList == null) {
            this.buildDimensionList();
        }
    }

    private void buildDimensionList() {
        this.dimensionList = new ArrayList<Integer>();
        String dimensionListString = ConfigManager.getConfig().getString("dimensions.list");
        if (!dimensionListString.isEmpty()) {
            Arrays.stream(dimensionListString.split(",")).forEach(o -> {
                try {
                    this.dimensionList.add(Integer.parseInt(o));
                }
                catch (NumberFormatException e) {
                    Matmos.LOGGER.warn("Ignoring invalid dimension number: " + o);
                }
            });
        }
        this.dimensionListIsWhitelist = ConfigManager.getConfig().getString("dimensions.listtype").contentEquals("white");
    }

    public void loadExpansions() {
        this.dispose();
        this.dealer.findResourcePacks().forEach(this::readSoundPack);
    }

    private void readSoundPack(IResourcePack pack) {
        try (InputStream matPackStream = this.dealer.openMatPackPointerFile(pack);
             InputStream expansionsStream = this.dealer.openExpansionsPointerFile(pack);){
            String matPackJSONString = IOUtils.toString((InputStream)matPackStream, (String)"UTF-8");
            String expansionsJSONString = IOUtils.toString((InputStream)expansionsStream, (String)"UTF-8");
            if (this.readMatPackFile(new JsonParser().parse(matPackJSONString).getAsJsonObject())) {
                this.readExpansionsFile(new JsonParser().parse(expansionsJSONString).getAsJsonObject(), pack);
            }
        }
        catch (Exception e) {
            Matmos.LOGGER.warn(pack + " has failed with an error: " + e.getMessage());
        }
    }

    private boolean readMatPackFile(JsonObject matPackRoot) {
        this.soundpackIdentities.add(new SoundpackIdentity(matPackRoot));
        return true;
    }

    private void readExpansionsFile(JsonObject expansionsRoot, IResourcePack pack) {
        JsonArray expansions = expansionsRoot.get("expansions").getAsJsonArray();
        for (JsonElement element : expansions) {
            JsonObject o = element.getAsJsonObject();
            String uniqueName = MAtUtil.sanitizeUniqueName(o.get("uniquename").getAsString());
            String friendlyName = o.get("friendlyname").getAsString();
            float volumeModifier = o.has("volumemodifier") ? o.get("volumemodifier").getAsFloat() : 1.0f;
            String pointer = o.get("pointer").getAsString();
            ResourceLocation location = new ResourceLocation("matmos", pointer);
            if (pack.func_110589_b(location)) {
                this.addExpansion(new ExpansionIdentity(uniqueName, friendlyName, pack, location, volumeModifier));
                continue;
            }
            Matmos.LOGGER.warn("An expansion pointer doesn't exist: " + pointer);
        }
    }

    private void addExpansion(ExpansionIdentity identity) {
        Expansion expansion = new Expansion(identity, this.data, this.collector, this.soundManager, this, new File(this.userconfigFolder, identity.getUniqueName() + ".cfg"));
        this.expansions.put(identity.getUniqueName(), expansion);
        if (identity.getLocation().func_110623_a().endsWith(".xml")) {
            String filename;
            File folder = new File(this.userconfigFolder, "DO NOT EDIT UNLESS COPIED/");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if ((filename = identity.getUniqueName() + ".json").startsWith("legacy__")) {
                filename = filename.substring("legacy__".length());
            }
            expansion.setLoadingAgent(new LegacyXMLLoadingAgent(new File(folder, filename)));
        } else {
            expansion.setLoadingAgent(new JsonLoadingAgent());
        }
        expansion.updateVolume();
    }

    public Map<String, Expansion> getExpansions() {
        return this.expansions;
    }

    public List<SoundpackIdentity> getSoundpackIdentities() {
        return this.soundpackIdentities;
    }

    public static ItemStack dealias(ItemStack is, DataPackage data) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        return new ItemStack(Item.func_150899_d((int)ExpansionManager.dealiasToID(is, data)), is.func_190916_E(), 0);
    }

    public static int dealiasToID(ItemStack is, DataPackage data) {
        if (is == null || is.func_190926_b()) {
            return -1;
        }
        return ExpansionManager.dealiasIDIfNotReferenced(Item.func_150891_b((Item)is.func_77973_b()), data, true);
    }

    public static Block dealias(Block b, DataPackage data) {
        if (b == null) {
            return null;
        }
        return Block.func_149729_e((int)ExpansionManager.dealiasToID(b, data));
    }

    public static int dealiasToID(Block b, DataPackage data) {
        if (b == null) {
            return -1;
        }
        return ExpansionManager.dealiasIDIfNotReferenced(Block.func_149682_b((Block)b), data, false);
    }

    private static int dealiasIDIfNotReferenced(int id, DataPackage data, boolean isItem) {
        if (data != null && data instanceof SheetDataPackage && ((SheetDataPackage)data).isIDReferenced(id, isItem)) {
            return id;
        }
        return dealiasMap.dealiasID(id, isItem);
    }

    private void synchronizeStable(Expansion expansion) {
        if (expansion == null) {
            return;
        }
        if (expansion.isActivated()) {
            if (expansion.getVolume() <= 0.0f) {
                expansion.deactivate();
            }
        } else if (expansion.getVolume() > 0.0f) {
            expansion.activate();
        }
    }

    public void synchronize() {
        this.expansions.values().forEach(this::synchronizeStable);
    }

    @Override
    public void onFrame(float f) {
        this.expansions.values().forEach(Expansion::simulate);
    }

    @Override
    public void onTick() {
        if (!this.lastDimension.isPresent() || MAtUtil.getPlayer().field_71093_bK != this.lastDimension.get()) {
            this.expansions.values().forEach(e -> e.setOverrideOff(!this.isDimensionAllowed(MAtUtil.getPlayer().field_71093_bK)));
            this.lastDimension = Optional.of(MAtUtil.getPlayer().field_71093_bK);
        }
        this.expansions.values().forEach(Expansion::evaluate);
    }

    private boolean isDimensionAllowed(int dimension) {
        boolean inList = this.dimensionList.contains(dimension);
        return this.dimensionListIsWhitelist ? inList : !inList;
    }

    public void setData(DataPackage data) {
        this.data = data;
    }

    public void setCollector(IDataCollector collector) {
        this.collector = collector;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolumeAndUpdate(float volume) {
        this.volume = volume;
        this.updateVolume();
    }

    @Override
    public void updateVolume() {
        this.expansions.values().forEach(Expansion::updateVolume);
    }

    public void interrupt() {
        this.expansions.values().forEach(Expansion::interrupt);
    }

    public void dispose() {
        this.expansions.values().forEach(Expansion::dispose);
    }

    public void saveConfig() {
        this.expansions.values().forEach(Expansion::saveConfig);
    }
}

