/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos;

import eu.ha3.matmos.lib.eu.ha3.util.property.simple.ConfigProperty;
import eu.ha3.matmos.util.DefaultConfigHelper;
import java.io.File;
import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"matmos");
    private static final ConfigProperty config = new ConfigProperty();
    private static boolean hasInitialized = false;
    public static final int DEFAULT_KEY = 62;
    private static final DefaultConfigHelper DEFAULT_CONFIG_HELPER = new DefaultConfigHelper("matmos");
    private static File configFolder = null;

    private static void initConfig() {
        config.setProperty("world.height", (Object)256);
        config.setProperty("start.enabled", true, "If false, MAtmos won't start until the MAtmos key is pressed.");
        config.setProperty("reversed.controls", (Object)false);
        config.setProperty("sound.autopreview", (Object)true);
        config.setProperty("globalvolume.scale", Float.valueOf(1.0f));
        config.setProperty("key.code", (Object)62);
        config.setProperty("useroptions.altitudes.high", (Object)true);
        config.setProperty("useroptions.altitudes.low", (Object)true);
        config.setProperty("useroptions.biome.override", (Object)-1);
        config.setProperty("debug.mode", (Object)0);
        config.setProperty("minecraftsound.ambient.volume", Float.valueOf(1.0f));
        config.setProperty("coremod.replacesoundsystem", "auto", "There's a bug in Minecraft's sound system that causes it to crash after some time if looping streams are played.\nForge provides a fix for this in 1.12.2, but MAtmos has to provide its own fix on 1.7.10, and on LiteLoader versions.\nUse this option to control when the SoundSystem should be overridden.\n\nAllowed values are: always, never, auto (which only overrides if no other mod is present which also overrides it (like DynamicSurroundings on 1.7.10, or Forge itself on 1.12.2))");
        config.setProperty("soundsystem.changechannelcount", "auto", "Configure sound system to be able to play more sounds at once. Note: Regardless of the setting, this can get overrriden by mods that change it after us (e.g. Dynamic Surroundings)\nTrue: always do this\nAuto: don't do this if another mod has done it before us\nFalse: never do this");
        config.setProperty("soundsystem.changechannelcount.normal", -1, "The number of normal channels (e.g. sound effects). The vanilla value is 28. Set to -1 to decide automatically.");
        config.setProperty("soundsystem.changechannelcount.streaming", -1, "The number of streaming channels (e.g. music, longer soundpack sounds). The vanilla value is 4. Set to -1 to decide automatically.");
        config.setProperty("soundsystem.changestreamqueueformatsmatch", true, "I forgot what this does, but it probably makes things faster. It is not known to cause any issues, but can be disabled here just in case.");
        config.setProperty("dimensions.list", "", "Comma-separated list of dimensions. If dimensions.listtype is black, then ambience will NOT be played in these dimensions.\nIf it's white, then ambience will ONLY play in these dimensions.\n");
        config.setProperty("dimensions.listtype", "black", "BLACK or WHITE?\n");
        config.setProperty("rain.suppress", "auto", "Use this option to control how the conflict should be resolved between MAtmos rain sounds\nand rain sounds from vanilla or other mods.\nTrue: rain from other sources is muted\nFalse: rain is muted from MAtmos soundpacks which support this option\nAuto: true if there's at least one soundpack which supports this option present, false otherwise\n");
        config.setProperty("rain.soundlist", "weather.rain,weather.rain.above,rain", "Comma-separated list of rain sounds to suppress if rain.suppress is true");
        config.setProperty("rain.strengththreshold", "-1", "Rain strength threshold above which it's considered to be raining by soundpacks\nRange: 0~1, or -1 to use the default setting, which is 0.2 in vanilla\nSet this to something low like 0 for better compatibility with Weather2\n");
        config.setProperty("dealias.oredict", "true", "Dealias oredicted blocks to the lowest id block of the oredict group.");
        config.setProperty("dealias.guessfromclass", "true", "Guess the aliases of items from their class and name");
        config.setProperty("log.category.aliasmap", "false", "Print log messages about alias map construction");
        config.setProperty("log.printcrashestochat", "true", "Display message in chat when MAtmos crashes");
        config.commit();
        config.setGlobalDescription("Tip: restart MAtmos to reload the configs without restarting Minecraft");
        try {
            config.setSource(new File(ConfigManager.getConfigFolder(), "userconfig.cfg").getCanonicalPath());
            config.load();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error caused config not to work: " + e.getMessage());
        }
        hasInitialized = true;
    }

    public static ConfigProperty getConfig() {
        if (!hasInitialized) {
            ConfigManager.initConfig();
        }
        return config;
    }

    public static File getConfigFolder() {
        if (configFolder == null) {
            configFolder = new File(Launch.minecraftHome, "config/matmos");
        }
        return configFolder;
    }

    public static DefaultConfigHelper getDefaultConfigHelper() {
        return DEFAULT_CONFIG_HELPER;
    }
}

