/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.util;

import elec332.core.util.InventoryHelper;
import elec332.core.util.ItemStackHelper;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WrappedItemHandler<I extends IItemHandlerModifiable>
implements IItemHandlerModifiable {
    private final I inventory;

    public static <I extends IItemHandlerModifiable> WrappedItemHandler<I> of(I inventory) {
        if (inventory == null) {
            throw new IllegalArgumentException();
        }
        return new WrappedItemHandler<I>(inventory);
    }

    private WrappedItemHandler(I inventory) {
        this.inventory = inventory;
    }

    @Nonnull
    public I getInventory() {
        return this.inventory;
    }

    public boolean addItemToInventory(ItemStack stack, boolean simulate) {
        return InventoryHelper.addItemToInventory(this.inventory, (ItemStack)stack, (boolean)simulate);
    }

    public int getFirstSlotWithItemStackNoNBT(ItemStack stack) {
        return InventoryHelper.getFirstSlotWithItemStackNoNBT(this.inventory, (ItemStack)stack);
    }

    public void copyContentsFrom(WrappedItemHandler<I> inventory) {
        this.copyContentsFrom(inventory.getInventory());
    }

    public void copyContentsFrom(I otherInventory) {
        for (int i = 0; i < otherInventory.getSlots(); ++i) {
            this.setStackInSlot(i, ItemStackHelper.copyItemStack((ItemStack)otherInventory.getStackInSlot(i)));
        }
    }

    public ItemStack[] getCopyOfContents() {
        ItemStack[] ret = new ItemStack[this.getSlots()];
        for (int i = 0; i < this.getSlots(); ++i) {
            ret[i] = ItemStackHelper.copyItemStack((ItemStack)this.getStackInSlot(i));
        }
        return ret;
    }

    public void setContents(ItemStack[] contents) {
        if (contents.length != this.getSlots()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < contents.length; ++i) {
            this.setStackInSlot(i, ItemStackHelper.copyItemStack((ItemStack)contents[i]));
        }
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.inventory.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.inventory.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }
}

