/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.util;

import com.google.common.collect.Lists;
import elec332.core.util.ItemStackHelper;
import elec332.craftingtableiv.util.WrappedRecipe;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class RecipeCache {
    private final List<Entry> recipes = Lists.newArrayList();
    private final List<Entry> shownRecipes = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WrappedRecipe> getAllRecipes() {
        List<Entry> list = this.recipes;
        synchronized (list) {
            return this.recipes.stream().map(e -> e.recipe).collect(Collectors.toList());
        }
    }

    public int getShownSize() {
        return this.shownRecipes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecipe(WrappedRecipe recipe, int amt, Predicate<WrappedRecipe> matcher) {
        Entry entry = new Entry(recipe, amt);
        List<Entry> list = this.recipes;
        synchronized (list) {
            if (matcher.test(recipe)) {
                this.shownRecipes.add(entry);
            }
            this.recipes.add(entry);
        }
    }

    public Entry getShownRecipe(int i) {
        return this.shownRecipes.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getRecipeOutput(int i) {
        List<Entry> list = this.recipes;
        synchronized (list) {
            Entry e = this.getShownRecipe(i);
            if (e == null) {
                return ItemStackHelper.NULL_STACK;
            }
            return e.recipe.getRecipeOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisual(Predicate<WrappedRecipe> stackMatcher) {
        List<Entry> list = this.recipes;
        synchronized (list) {
            this.shownRecipes.clear();
            for (Entry wrappedRecipe : this.recipes) {
                if (!stackMatcher.test(wrappedRecipe.recipe)) continue;
                this.shownRecipes.add(wrappedRecipe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecipes() {
        List<Entry> list = this.recipes;
        synchronized (list) {
            this.recipes.clear();
            this.shownRecipes.clear();
        }
    }

    public static class Entry {
        public final int amount;
        public final WrappedRecipe recipe;

        private Entry(WrappedRecipe recipe, int amount) {
            this.amount = amount;
            this.recipe = recipe;
        }
    }
}

