/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.util.ItemStackHelper;
import elec332.craftingtableiv.CraftingTableIV;
import elec332.craftingtableiv.util.ItemComparator;
import elec332.craftingtableiv.util.WrappedRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class FastRecipeList {
    private final Map<String, Map<ItemComparator, List<WrappedRecipe>>> recipeHash = Maps.newHashMap();

    public FastRecipeList(List<WrappedRecipe> recipes) {
        this();
        for (WrappedRecipe recipe : recipes) {
            this.addRecipe(recipe);
        }
    }

    public FastRecipeList() {
    }

    public void addRecipe(WrappedRecipe recipe) {
        ItemComparator itemComparator = new ItemComparator(recipe.getRecipe().func_77571_b());
        String s = CraftingTableIV.getItemIdentifier(itemComparator.getStack());
        this.recipeHash.computeIfAbsent(s, k -> Maps.newHashMap()).computeIfAbsent(itemComparator, k -> Lists.newArrayList()).add(recipe);
    }

    public List<WrappedRecipe> getCraftingRecipe(Ingredient ingredient, WrappedRecipe owner) {
        return Arrays.stream(owner.getRecipeHandler().getMatchingStacks(owner.getRecipe(), ingredient)).filter(ItemStackHelper::isStackValid).map(this::getCraftingRecipe).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<WrappedRecipe> getCraftingRecipe(ItemStack stack) {
        List<WrappedRecipe> possRet;
        if (!ItemStackHelper.isStackValid((ItemStack)stack)) {
            return ImmutableList.of();
        }
        try {
            possRet = this.recipeHash.get(CraftingTableIV.getItemIdentifier(stack)).get(new ItemComparator(stack));
        }
        catch (Exception e) {
            return ImmutableList.of();
        }
        if (possRet == null || possRet.isEmpty()) {
            return ImmutableList.of();
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            return possRet;
        }
        ArrayList ret = Lists.newArrayList();
        for (WrappedRecipe recipe : possRet) {
            ItemStack out = recipe.getRecipeOutput();
            if (out.func_77952_i() != stack.func_77952_i() && (out.func_77981_g() || stack.func_77981_g())) continue;
            ret.add(recipe);
        }
        return ret;
    }

    public List<WrappedRecipe> getCraftingRecipe(List<ItemStack> stacks) {
        ArrayList ret = Lists.newArrayList();
        for (ItemStack stack : stacks) {
            ret.addAll(this.getCraftingRecipe(stack));
        }
        return ret;
    }

    public boolean removeRecipe(WrappedRecipe recipe) {
        return this.recipeHash.get(recipe.getIdentifier()).get(new ItemComparator(recipe.getRecipeOutput())).remove(recipe);
    }

    public void removeAllRecipes(List<WrappedRecipe> recipes) {
        for (WrappedRecipe recipe : recipes) {
            this.removeRecipe(recipe);
        }
    }

    public FastRecipeList copyOf() {
        FastRecipeList ret = new FastRecipeList();
        for (Map.Entry<String, Map<ItemComparator, List<WrappedRecipe>>> entry : this.recipeHash.entrySet()) {
            ret.recipeHash.put(entry.getKey(), Maps.newHashMap());
            for (Map.Entry<ItemComparator, List<WrappedRecipe>> comparatorListEntry : this.recipeHash.get(entry.getKey()).entrySet()) {
                ret.recipeHash.get(entry.getKey()).put(comparatorListEntry.getKey().copy(), Lists.newArrayList());
                for (WrappedRecipe recipe : this.recipeHash.get(entry.getKey()).get(comparatorListEntry.getKey())) {
                    ret.recipeHash.get(entry.getKey()).get(comparatorListEntry.getKey()).add(recipe);
                }
            }
        }
        return ret;
    }
}

