/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.tileentity;

import elec332.core.inventory.BasicItemHandler;
import elec332.core.tile.AbstractTileEntity;
import elec332.core.util.IBlockStateHelper;
import elec332.core.world.WorldHelper;
import elec332.craftingtableiv.CraftingTableIV;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityCraftingTableIV
extends AbstractTileEntity
implements ITickable,
IItemHandlerModifiable {
    public boolean showRecipeSize = true;
    public boolean showShaped = true;
    public float doorAngle = 0.0f;
    private BasicItemHandler inventory = new BasicItemHandler(18);
    private static final float openspeed = 0.2f;
    private int tablestate = 0;
    private int facing = -1;

    public int getFacing() {
        if (this.facing == -1) {
            this.facing = ((EnumFacing)WorldHelper.getBlockState((IBlockAccess)this.func_145831_w(), (BlockPos)this.field_174879_c).func_177229_b(IBlockStateHelper.FACING_NORMAL.getProperty())).func_176736_b() + 2;
        }
        return this.facing;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        this.showRecipeSize = tagCompound.func_74767_n("shR");
        this.showShaped = tagCompound.func_74767_n("ssH");
        this.inventory.writeToNBT(tagCompound);
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("shR", this.showRecipeSize);
        tagCompound.func_74757_a("ssH", this.showShaped);
        this.inventory.deserializeNBT(tagCompound);
        super.func_145839_a(tagCompound);
    }

    public void func_73660_a() {
        if (CraftingTableIV.enableDoor) {
            int xCoord = this.field_174879_c.func_177958_n();
            int yCoord = this.field_174879_c.func_177956_o();
            int zCoord = this.field_174879_c.func_177952_p();
            EntityPlayer entityplayer = this.func_145831_w().func_184137_a((double)((float)xCoord + 0.5f), (double)((float)yCoord + 0.5f), (double)((float)zCoord + 0.5f), 10.0, false);
            if (entityplayer != null) {
                double playerDistance = entityplayer.func_70092_e((double)xCoord, (double)yCoord, (double)zCoord);
                if (playerDistance < (double)CraftingTableIV.doorRange) {
                    this.doorAngle += 0.2f;
                    if (this.tablestate != 1) {
                        this.tablestate = 1;
                        if (CraftingTableIV.enableNoise) {
                            this.func_145831_w().func_184148_a(null, (double)xCoord, (double)yCoord + 0.5, (double)zCoord, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.2f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.2f);
                        }
                    }
                    if (this.doorAngle > 1.8f) {
                        this.doorAngle = 1.8f;
                    }
                } else if (playerDistance > (double)CraftingTableIV.doorRange) {
                    this.doorAngle -= 0.2f;
                    if (this.tablestate != 0) {
                        this.tablestate = 0;
                        if (CraftingTableIV.enableNoise) {
                            this.func_145831_w().func_184148_a(null, (double)xCoord, (double)yCoord + 0.5, (double)zCoord, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.2f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.2f);
                        }
                    }
                    if (this.doorAngle < 0.0f) {
                        this.doorAngle = 0.0f;
                    }
                }
            }
        }
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.inventory.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.inventory.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }
}

